/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.log;

import ej.hoka.http.Config;

/**
 * Factory class for the logger.
 */
public class LoggerFactory {

	/**
	 * You can set a logger implementation using the system property {@code hoka.logger.class}
	 *
	 * If the system property if not set or the class from {@code hoka.logger.class} is not found or can't be accessed
	 * or instantiated. an instance of {@link SimpleLogger} is returned with log to the standard output.
	 *
	 * @return logger instance of configured logger.
	 */
	public static Logger getLogger() {
		String className = Config.getInstance().getLoggerClassName();
		if (className == null || className.isEmpty() || className.trim().isEmpty()) {
			return new SimpleLogger();
		}
		try {
			Class<?> clazz = Class.forName(className.trim());
			return (Logger) clazz.newInstance();
		} catch (ClassNotFoundException | InstantiationException | IllegalAccessException e) {
			Logger logger = new SimpleLogger();
			logger.error("'" + className + "' logger not found", e); //$NON-NLS-1$ //$NON-NLS-2$
			return logger;
		}

	}

}
