/*
 * Java
 *
 * Copyright 2022 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg;

import ej.microui.display.GraphicsContext;
import ej.microvg.VectorGraphicsPainter.FillType;

/**
 * A builder for vector images.
 *
 * <p>
 * Users can add the paths that compose the image and build the corresponding {@link VectorImage} instance. The paths
 * will be drawn in the order of addition.
 */
public class VectorImageBuilder {

	/**
	 * Creates a new builder for vector images.
	 *
	 * @param width
	 *            the width of the image
	 * @param height
	 *            the height of the image
	 * @throws IllegalArgumentException
	 *             if either <code>width</code> or <code>height</code> is negative or zero.
	 */
	public VectorImageBuilder(float width, float height) {
		throw new VectorGraphicsException();
	}

	/**
	 * Adds the given path with specified color and fill type.
	 *
	 * <p>
	 * The given color value is interpreted as a 32-bit ARGB color, where the high-order byte is the alpha channel and
	 * the remaining bytes contain the red, green and blue channels, respectively. A fully opaque color will have an
	 * alpha of {@code 255}, while a fully transparent color will have an alpha of {@code 0}. For example, passing the
	 * color {@code 0xff0000ff} to this method results in a path with an opaque blue fill.
	 *
	 * <p>
	 * If the specified color is fully transparent ({@code 0x00} for the alpha channel), the path is not added.
	 *
	 * @param path
	 *            the path to add
	 * @param color
	 *            the color to fill the path with
	 * @param fillType
	 *            the fill type to use
	 * @return the builder instance.
	 * @see GraphicsContext#OPAQUE
	 * @see GraphicsContext#TRANSPARENT
	 */
	public VectorImageBuilder addPath(Path path, int color, FillType fillType) {
		throw new VectorGraphicsException();
	}

	/**
	 * Adds the given path with specified gradient and fill type.
	 *
	 * <p>
	 * The colors of the gradient are interpreted as 32-bit ARGB colors, where the high-order byte is the alpha channel
	 * and the remaining bytes contain the red, green and blue channels, respectively. A fully opaque color will have an
	 * alpha of {@code 255}, while a fully transparent color will have an alpha of {@code 0}. For example, the color
	 * {@code 0xff0000ff} results in an opaque blue.
	 *
	 * @param path
	 *            the path to add
	 * @param gradient
	 *            the gradient to fill the path with
	 * @param fillType
	 *            the fill type to use
	 * @return the builder instance.
	 * @see GraphicsContext#OPAQUE
	 * @see GraphicsContext#TRANSPARENT
	 */
	public VectorImageBuilder addGradientPath(Path path, LinearGradient gradient, FillType fillType) {
		throw new VectorGraphicsException();
	}

	/**
	 * Creates the vector image from the builder state.
	 * <p>
	 * The returned image is allocated dynamically and must be closed explicitly.
	 *
	 * @return a vector image
	 */
	public ResourceVectorImage build() {
		throw new VectorGraphicsException();
	}
}
