/*
 *	Java
 *
 *	Copyright 2015-2017 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * This class holds a context in order to draw images with scaling.<br>
 * <p>
 * An image scale instance holds a global state for all drawings. Several instances can be created at the same time.
 * However a default instance is created on MicroUI framework startup and is always available.<br>
 *
 * @since 2.0
 */
public class ImageScale extends AbstractTransform {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static ImageScale Singleton = new ImageScale();

	/**
	 * @deprecated Use {@link #getFactorX()} or {@link #getFactorY()} instead.
	 *
	 * @return the current scaling X factor.
	 */
	public float getFactor() {
		throw new RuntimeException();
	}
	
	/**
	 * Returns the current scaling X factor.
	 *
	 * @return the current scaling X factor.
	 */
	public float getFactorX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current scaling Y factor.
	 *
	 * @return the current scaling Y factor.
	 */
	public float getFactorY() {
		throw new RuntimeException();
	}

	/**
	 * Set a new scaling factor. Equivalent to <br>
	 * <code>
	 * setFactorX(factor);<br>
	 * setFactorY(factor);<br>
	 * </code> 
	 *
	 * @param factor
	 *            the new scaling factor
	 * @throws IllegalArgumentException
	 *             if <code>factor</code> is lower than or equal to zero
	 */
	public void setFactor(float factor) {
		throw new RuntimeException();
	}
	
	/**
	 * Set a new scaling X factor.
	 *
	 * @param factor
	 *            the new scaling X factor
	 * @throws IllegalArgumentException
	 *             if <code>factor</code> is lower than or equal to zero
	 */
	public void setFactorX(float factor) {
		throw new RuntimeException();
	}

	/**
	 * Set a new scaling Y factor.
	 *
	 * @param factor
	 *            the new scaling Y factor
	 * @throws IllegalArgumentException
	 *             if <code>factor</code> is lower than or equal to zero
	 */
	public void setFactorY(float factor) {
		throw new RuntimeException();
	}

	/**
	 * @deprecated Use {@link #drawNearestNeighbor(GraphicsContext, Image, int, int, int)} or {@link #drawBilinear(GraphicsContext, Image, int, int, int)}
	 *             instead.
	 *             
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 */
	public void draw(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}
	
	/**
	 * Draw the {@link Image} in the {@link GraphicsContext} at given anchor position and using the current scaling
	 * factor. This method uses the <code>bilinear</code> algorithm
	 * to render the image. This algorithm performs better rendering than <code>nearest neighbor</code> algorithm but it
	 * is slower to apply.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 */
	public void drawBilinear(GraphicsContext gc, Image image, int x, int y,
			int anchor) {
		throw new RuntimeException();
	}

	/**
	 * Draw the {@link Image} in the {@link GraphicsContext} at given anchor position and using the current scaling
	 * factor. This method uses the <code>nearest neighbor</code>
	 * algorithm to render the image. This algorithm is faster than <code>bilinear</code> algorithm but its rendering is
	 * more simple.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 */
	public void drawNearestNeighbor(GraphicsContext gc, Image image, int x,
			int y, int anchor) {
		throw new RuntimeException();
	}
}
