#!/bin/bash
#
# BASH
#
# Copyright 2023-2024 MicroEJ Corp. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be found with this software.

LOCAL_ENV_FILE=set_local_env.sh
if [ -f "$LOCAL_ENV_FILE" ]; then
. $LOCAL_ENV_FILE
else
	echo ""
	echo "ERROR: Missing set_local_env.sh script."
	echo "For local build, please create it using set_local_env.sh.tpl as example."
	echo ""
	exit -1
fi

if [ ! -d "$APP_SDK_INSTALL" ]; then
	echo ""
	echo "ERROR: APP_SDK_INSTALL="$APP_SDK_INSTALL" is not a valid path."
	echo "Please verify set_local_env.sh"
	echo ""
	exit -1
fi

. "$APP_SDK_INSTALL/environment-setup-armv7at2hf-neon-vfpv4-oemllib32-linux-gnueabi"
