/*
 * Java
 *
 * Copyright 2017-2020 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.synchronous;

import java.io.IOException;

import ej.annotation.Nullable;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;

public abstract class Command<T> {

	public static final Object VOID_RESPONSE = new Object();

	private @Nullable T response;

	public abstract String getName();

	/**
	 * Writes the body of the command.
	 *
	 * @param sender
	 *            the sender used to send the command.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public abstract void writeBody(CommandSender sender) throws IOException;

	public void readResponse(CommandReader reader) throws IOException {
		this.response = readResponseInternal(reader);
	}

	/**
	 * Reads and returns the response from the reader.
	 *
	 * @param reader
	 *            the reader used to read the response.
	 * @return the response.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	protected abstract T readResponseInternal(CommandReader reader) throws IOException;

	public @Nullable T getResponse() {
		return this.response;
	}

	public boolean isResponseReceived() {
		return (this.response != null);
	}
}
