/*
 * Java
 *
 * Copyright 2015-2020 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand.impl;

import ej.annotation.Nullable;
import ej.rcommand.RemoteCommandListener;

/**
 * A {@link ej.rcommand.RemoteCommandManager} that dispatches all the unknown command to the
 * {@link ej.rcommand.CommandSender}.
 */
public class GatewayRemoteCommandManager extends DefaultRemoteCommandManager{

	private final CommandDispatchService dispatchService;

	public GatewayRemoteCommandManager(boolean overwrite){
		super(overwrite);
		this.dispatchService = new CommandDispatchService();
		this.dispatchService.initialize(this);
	}

	public GatewayRemoteCommandManager(){
		this(false);
	}

	@Override
	protected @Nullable RemoteCommandListener getListenerFor(String command) {
		RemoteCommandListener listener = super.getListenerFor(command);
		if(listener == null){
			listener = this.dispatchService;
		}
		return listener;
	}

}
