/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hal;

/**
 * Unchecked exception thrown when error occurred during {@link WatchdogTimer}
 * operations.
 */
public class WatchdogTimerException extends RuntimeException {

	/**
	 * Default Constructor for {@link WatchdogTimerException}.
	 */
	public WatchdogTimerException() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@link WatchdogTimerException} with the specified message and
	 * cause.
	 *
	 * @param message the detail message. The detail message is saved for later
	 *                retrieval by the {@link #getMessage()} method.
	 *
	 * @param cause   the cause (which is saved for later retrieval by the
	 *                {@link #getCause()} method). (A <tt>null</tt> value is
	 *                permitted, and indicates that the cause is nonexistent or
	 *                unknown.)
	 *
	 */
	public WatchdogTimerException(String message, Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@link WatchdogTimerException} with the specified cause.
	 *
	 * @param cause the cause (which is saved for later retrieval by the
	 *              {@link #getCause()} method). (A <tt>null</tt> value is
	 *              permitted, and indicates that the cause is nonexistent or
	 *              unknown.)
	 *
	 */
	public WatchdogTimerException(Throwable cause) {
		throw new RuntimeException();
	}
}
