# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [8.3.4] - 2021-08-12

### Fixed
- An issue where the thread managing server sessions wasn't correctly scheduled.

### Changed
- Marked APIs with annotations for Null Analysis.
- Updated implementation code to comply with Null Analysis.
- API deprecated and will be removed in next major release:
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String)' has been deprecated
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String, int)' has been deprecated
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String, int, boolean, boolean)' has been deprecated
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, boolean, boolean)' has been deprecated
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.util.Date, boolean, boolean)' has been deprecated
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(java.lang.String, java.lang.String, java.lang.String, java.lang.String, int, java.util.Date, boolean, boolean, ej.hoka.http.Cookie$SameSite)' has been deprecated

### Added
-  New API to manage Cookies:
    - ej.hoka.http.Cookie: Method 'public java.util.Date getExpires()' has been added
    - ej.hoka.http.Cookie: Method 'public java.lang.String getDomain()' has been added
    - ej.hoka.http.Cookie: Method 'public ej.hoka.http.Cookie$Builder builder()' has been added
    - ej.hoka.http.Cookie: Method 'public int getMaxAge()' has been added
    - ej.hoka.http.Cookie: Method 'public java.lang.String getName()' has been added
    - ej.hoka.http.Cookie: Method 'public java.lang.String getPath()' has been added
    - ej.hoka.http.Cookie: Method 'public ej.hoka.http.Cookie$SameSite getSameSite()' has been added
    - ej.hoka.http.Cookie: Method 'public java.lang.String getValue()' has been added
    - ej.hoka.http.Cookie: Method 'public boolean isHttpOnly()' has been added
    - ej.hoka.http.Cookie: Method 'public boolean isSecure()' has been added
    - ej.hoka.http.Cookie$Builder: Class ej.hoka.http.Cookie$Builder added
    - ej.hoka.http.HttpResponse: Method 'public void addCookie(ej.hoka.http.Cookie)' has been added
    - ej.hoka.http.HttpResponse: Method 'public ej.hoka.http.Cookie removeCookie(java.lang.String)' has been added


## [8.3.3] - 2021-06-11
### Changed
- Upgrade ej.library.runtime#property to version 4.1.0

## [8.3.2] - 2021-05-26
### Changed
  - Upgrade test platform (Wrover HDAHT) to 1.8.0 version

## [8.3.1] - 2021-05-11
### Fixed
  - Fix documentation link.

## [8.3.0] - 2021-03-25
### Added
  - Add SameSite support for response cookie

### Fixed
  - Remove extra space after reason phrase in HTTP header line.
    
## [8.2.0] - 2021-03-12
### Added
  - Add support of Expires attribute in cookie
  
### Fixed
  - Server configuration, can be provided through /hoka.properties on the app classpath

## [8.1.0] - 2021-03-12
### Added
 - add support for HTTP/1.1 methods HEAD, CONNECT, OPTIONS, TRACE, PATCH

## [8.0.1] - 2021-03-10
### Fixed
 - fix net::ERR_INCOMPLETE_CHUNKED_ENCODING issue

## [8.0.0] - 2021-03-05
### Added
 - add support to path params /api/user/:id
 - add support to splat params /api/say/*/to/*
 - new API to register HTTP routes
 - support of before/after global or on a specific path filters
 - support of exception mapping to a request handler
 - 404 Not Found and 500 internal server errors can be customized
 - 405 Method Not Allowed support
 - static files handler
 - new logging system
 - add server instance builder
 - support of trailing forward slash in request URI
 
### Fixed
 - set multiple cookies
 - strict content encoding support 406 not accepted when encoding is not know by the server
 
## [7.1.2] - 2021-02-09
### Fixed
 - J0153H-29: Fix global URI matching conflicting with the same non-global URI.

## [7.1.1] - 2020-02-18

### Changed

  - Update ej.api.edc library to version 1.3.0.
  - Update ej.api.bon library to version 1.4.0.
  - Update ej.api.net library to version 1.1.1.
  - Update ej.library.eclasspath.base64 library to version 1.1.0.
  - Update ej.library.runtime.basictool library to version 1.3.0.

## [7.1.0] - 2020-02-04

### Changed

  - Update the user manual.
  - Optimize MultipartBodyParser (getBoundaryIndex).
  
### Deprecated

  - SessionAuthenticator constructors that use the default Random implementation.

### Removed

  - Remove SSL dependency used by SessionAuthenticator to generate secure session IDs.

### Fixed

  - Fix HTTPServer.getHtmlExceptionStackTrace() OutOfBounds exception that was thrown when the first 
    element of the stack trace wasn't a part of the java.lang package.

## [7.0.0] - 2019-12-10

### Changed

  - Change the static HTTPSession to the RequestHandler customizable mechanism
  - Move encoding registering to a dedicated class.
  - Change the request's body parsing API.

### Added

  - Add timeout mechanism to cleanup HTTP inactive connections.
  - Merge REST library.
  - Merge authentication library.

## [6.0.0] - 2019-10-31

### Added

  - Add default parameters constructors.

### Changed

  - Replace abstract method HTTPServer#newHTTPSession(HTTPSession) with an abstract factory inner class to HTTPSession that subclasses can implement.
  - Use ServerSocketFactory instead of ServerSocket.

## [5.1.0] - 2019-03-13

### Changed

  - Use MMM.

## [5.0.0] - 2018-11-21

### Added

  - Add multi part body parser.
  - Move previous multipart parsing into StringBodyParser
  - Use Map instead of Hashtable
  - Use StrngBuilder instead of string buffer.
  - Sonar review
  
## [4.1.1] - 2018-12-26

### Added

  - J0153H-8 Hoka jobs should wait until a new connection is added.

## [4.1.0] - 2018-09-04

### Added

  - J0153H-4 Use buffer input stream to optimize speed.
  
## [4.0.0] - 2018-02-16

### Fixed

  - J0153H-2 Use a standard logger.
  
### Added

  - J0153H-3 Add body parser factory to the server.
  
## [3.0.0] - 2017-08-21

### Added

  - Use net library and remove net interfaces.

## [2.1.1] - 2017-06-23

### Added

  - Add build component.
  
## [2.1.0] - 2017-04-06

### Added

  - Add possibility to parse the body.
  
## [2.0.0] - 2016-10-12

### Added

  - Initial  revision.
  
---  
_Markdown_  
_Copyright 2017-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  