# Overview

This library contains the Date and Time API for Java.

An application can set the default zone rules provider by setting the value of the
constant `java.time.zone.DefaultZoneRulesProvider` to be the fully qualified name of the provider.
The library defines a default provider for zone rules: `java.time.zone.DefaultZoneRulesProvider`.

## TZDB Zone Rules Provider

The library also defines a provider of zone-rules for the time-zones defined in the IANA Time Zone Database (TZDB).
The TZDB provider reads the zones and rules from a raw resource at runtime.
Compared to the `TzdbZoneRulesProvider` of Java SE, this implementation uses less Java heap at runtime to be more 
suitable to embedded devices.

To use this provider, set the constant `java.time.zone.DefaultZoneRulesProvider` to `java.time.zone.TzdbZoneRulesProvider`.
It is also required to add the class name `java.time.zone.TzdbZoneRulesProvider` to a `*.types.list` file.

The raw resource from which the provider reads the zone rules is generated from the timezone database file included in 
the JDK/JRE installation (`tzdb.dat`).
To generate the resource and use it in an application, do the following:

1. Locate the `tzdb.dat` file in a local JDK/JRE installation (`path/to/JRE/lib/tzdb.dat`),
2. Add the `tzdb.dat` file to the application resources (e.g., `src/main/resources/com/mycompany/tzdb.dat`),
3. Create a `*.tzdb.list` file in the application resources (e.g., `src/main/resources/com/mycompany/myapp.tzdb.list`),
4. Open the `*.tzdb.list` file and add the path to the `tzdb.dat` file (e.g., `/com/mycompany/tzdb.dat`).

The resource will be automatically generated when building the application or running it in the Simulator.

The `tzdb` Add-On Processor will automatically process the specified `tzdb.dat` file, and convert it into a format 
compatible with the TZDB provider (`TzdbZoneRulesProvider`).
The following files are generated in `src-adpgenerated/tzdb/java`:
- a `.resourcebuffer`, a resource buffer
- a `.resourcebuffer.list` which references the `.resourcebuffer`
- a `.resources.list` which references the resource file to embed (`/java/time/zone/tzdb`)

The `/java/time/zone/tzdb` resource will be generated from the `.resourcebuffer` when building the application or 
running it in the Simulator.

Since the generated resource is referenced by the generated `.resources.list`, the SOAR will embed the resource in the 
application binary (internal resource).

The resource can be declared as an external resource to be loaded from another location (e.g. from a FileSystem).
It has to be referenced in a ``*.externresources.list`` file, in which case the SOAR will output the resource in the 
external resources folder.
This resource must be transferred to the target device's memory and loaded from the path ``/java/time/zone/tzdb``, using 
the external resources loader.

## TZDB Updates 

To get a `tzdb.dat` with the most current timezone data available, use the [TZUpdater tool](https://www.oracle.com/java/technologies/downloads/tools/#TZUpdater) from Oracle and run 
the following command:

```
java -jar tzupdater.jar -l
```

The TZUpdater tool updates the JDK/JRE instance that is used to execute the tool: copy `path/to/JRE/lib/tzdb.dat` into 
the application resources, as described above. 
You can check that the version of the timezone data is correct in the logs of the Add-on Processor that generates the raw resource.


# Usage

Add the following line to your `module.ivy`:

    `<dependency org="ej.library.eclasspath" name="time" rev="1.1.0" />`

Add the following line to your `build.gradle.kts`:

    `implementation("ej.library.eclasspath:time:1.1.0")`

# Requirements

This library requires the following Foundation Libraries:

    EDC 1.3, BON 1.4

When using the TZDB zone rules provider (`java.time.zone.TzdbZoneRulesProvider`), it is required to use
architectures `7.20.5+` (for 7.x) or `8.1.1+` (for 8.x).

# Dependencies

N/A

# Source

- OpenJDK 8 u362-ga

# Restrictions

- Removed the non-ISO chronologies classes (`Hijrah*`, `Japanese*`, `Minguo*`, `ThaiBuddhist*`).
- Removed all the classes of package `java.time.format` (all but `ResolverStyle`).
- Replaced the original OpenJDK class `TzdbZoneRulesProvider` with a custom implementation.
- Removed the methods `parse`, `format`, `getDisplayName` and `ofLocale` for all types.
- Removed `@FunctionalInterface` keyword in interfaces.
- Removed `static` methods in all interfaces (see below).
- Removed `default` keyword in all interfaces (pulled down in concrete types).
- Removed the static method `TemporalAdjusters.ofDateAdjuster(UnaryOperator<LocalDate> dateBasedAdjuster)`.
- Removed the static method `WeekFields.of(Locale locale)`.
- Moved the static interface method `timeLineOrder` from the interfaces `ChronoLocalDate`, `ChronoLocalDateTime`
  and `ChronoZonedDateTime` to the concrete types `LocalDate`, `LocalDateTime` and `ZonedDateTime` (resp.).
- Removed overflow checks on calculations and related `throws ArithmeticException`.
- Removed null checks on method arguments (rely on javadoc and annotations to enforce non-null behavior).
- Removed the method `registerProvider(ZoneRulesProvider provider)` from the class `ZoneRulesProvider`. Set
  the value of the constant `java.time.zone.DefaultZoneRulesProvider` to the Full Qualified name of the provider class. 
- Remove the `toString()` methods in the classes of package `java.time.zone`.

## Interface static methods

- `java.time.chrono.ChronoLocalDate.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoLocalDate.timeLineOrder()`: **removed**, use `java.time.LocalDate.timeLineOrder()` instead
- `java.time.chrono.ChronoLocalDateTime.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoLocalDateTime.timeLineOrder()`: **removed**, use `java.time.LocalDateTime.timeLineOrder()`
  instead
- `java.time.chrono.ChronoZonedDateTime.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoZonedDateTime.timeLineOrder()`:: **removed**, use `java.time.ZonedDateTime.timeLineOrder()`
  instead
- `java.time.chrono.ChronoPeriod.between(ChronoLocalDate, ChronoLocalDate)`: **removed**
- `java.time.chrono.Chronology.from(TemporalAccessor)`: **removed**,
  use `java.time.chrono.AbstractChronology.from(TemporalAccessor)` instead
- `java.time.chrono.Chronology.getAvailableChronologies()`: **removed**,
  use `java.time.chrono.AbstractChronology.getAvailableChronologies()` instead
- `java.time.chrono.Chronology.of(String)`: **removed**, use `java.time.chrono.AbstractChronology.of(String)` instead
- `java.time.chrono.Chronology.ofLocale(Locale)`: **removed**

---    
_Markdown_  
_Copyright 2023-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp._
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._
_ _
_This code is free software; you can redistribute it and/or modify it_
_under the terms of the GNU General Public License version 2 only, as_
_published by the Free Software Foundation. Oracle designates this_
_particular file as subject to the "Classpath" exception as provided_
_by Oracle in the LICENSE file that accompanied this code._
_ _
_This code is distributed in the hope that it will be useful, but WITHOUT_
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_
_FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License_
_version 2 for more details (a copy is included in the LICENSE file that_
_accompanied this code)._
_ _
_You should have received a copy of the GNU General Public License version_
_2 along with this work; if not, write to the Free Software Foundation,_
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._
_ _
_Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA_
_or visit www.oracle.com if you need additional information or have any_
_questions. _