# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [4.0.0] - 2024-10-09

### VEE Port Requirements

- MicroVG API 1.5
- VG Pack 1.7.0
- C Module MicroVG 7.0.0

### Added

- Add some tests that use a MicroVG font as a MicroUI font.

### Fixed

- Increment the tolerance of `testMeasureTwoCharacters`. 

## [3.0.0] - 2024-07-19

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.6.0
- C Module MicroVG 6.0.0

### Added

- Add a test that uses MicroVG before MicroUI startup.
- Add target-specific property files.
- Add the ability to skip individual tests by setting properties.
- Add a test that draws the MicroUI shapes compatible with the GPU in a BufferedVectorImage.
- Add a test that draws an image just after a flush.

### Changed

- Improve complex layout text tests.
  - Add `testDrawGradientString`.
  - Add `testDrawGradientStringAndRotation`.
  - Add `testDrawGradientStringAndScale`.
  - Remove `testDrawStringLayoutTransform`.

### Fixed

- Fix the test naming in `TestBufferedVectorImage`.
- Fix the test `TestFontFlushLimits` (not compatible with UI Pack 14).

### Removed

- Remove some checks on the target (emb, sim, android, javafx): each test can be ignored by the testsuite launcher.
- Remove the configuration of the number of loops of the tests `testParallelDrawingInClosedImage()` and `testParallelDrawingClosedImage()`. 

## [2.7.0] - 2024-04-11

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.5.1
- C Module MicroVG 5.0.0

### Added

- Add system properties to skip specific tests.
  - Add the constant `tests.gradients.skip` to skip gradient tests.
  - Add the constant `tests.TestPath.testVeryLongDynamicPath.skip` to skip `TestPath.testVeryLongDynamicPath`.
- Add tests to draw a VG RAW image on a BufferedVectorImage with source and / or destination clip(s).
- Add tests to draw a BufferedVectorImage on a BufferedVectorImage with source and / or destination clip(s).
- Add a test for glyph path overlap.

## [2.6.0] - 2024-02-15

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.5.0
- C Module MicroVG 5.0.0

### Added

- Add tests when loading fonts (empty paths, missing leading slash).
- Add tests when getting images (empty paths).
- Add a test for memory leak on BufferedVectorImage.
- Add a test for color matrix on BufferedVectorImage.
 
### Changed

- Align tests when getting images with tests when loading fonts.  
- Fix some tests to be compatible with UI Pack 14.0.0

### Removed

- Cannot test flush bounds anymore (since UI Pack 14.0.0).

## [2.5.0] - 2023-11-13

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.4.2
- C Module MicroVG 4.0.0

### Added

- Add a test for very long dynamic paths (larger than 64 KB).
  
### Fixed

- Reduce the precision of the test `TestMatrix`.
- Fix the test `TestFontComplexLayoutOnCircle` on displays other than 392x392. 
- Fix the test `testStringWithSpace()` with a space inside the string.

## [2.4.0] - 2023-09-21

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.4.1
- C Module MicroVG 3.0.1

### Added

- Add a test for `MOVE_REL` path command. 
- Add test cases for translated Graphics Context.
- Add test cases (drawings and measures) for several kinds of characters. 
  
### Changed

- Update the license. 
- Ask for an explicit `flush()` instead of a `requestFlush()`.
- Split the tests with clip (`testPathWithClip()` and `testGradientWithClip()`) in 3 tests (large, fit and thin clip).
- Reduce the scope of several tests to check only what is expected by the test.
- Improve debugging traces. 
  
### Fixed

- Fix the end of test `TestBufferedVectorImageOOM` to avoid losing the last traces.
- Fix `TestFontComplexLayout` and `TestFontComplexLayoutOnCircle` tests on Android by increasing pixel comparison tolerance.

## [2.3.0] - 2023-07-21

### VEE Port Requirements

- MicroVG API 1.4
- VG Pack 1.4.0
- C Module MicroVG 3.0.0

### Added

- Add test cases for DST_OUT and PLUS blend modes.
- Add tests for path bounds.
- Add tests to check that loading a font from a path without a leading slash fails.
- Add tests for drawing empty strings and strings outside of the clip area.

### Fixed

- Make BVI tests compatible with Android.
- Do not print debug logs in TestFontMeasures, TestImageExternal and TestPath when the debug constant is not set.

## [2.2.0] - 2023-05-10

### VEE Port Requirements

- MicroVG API 1.3
- VG Pack 1.3.0
- C Module MicroVG 3.0.0

### Added

- Add tests on invalid "external images".
- Add compatibility tests to check that BufferedVectorImage can be used in place of VectorImage in the API.
- Add a test for memory leaks when closing a BufferedVectorImage.
- Add a test to check an image with several gradients.
- Add a test for an animated images with different path interpolators.
- Add tests to check out-of-memory error reporting when using BufferedVectorImages.
  
### Changed

- Publish the testsuite jar in addition with to the rip file.
  
### Fixed

- Fix "external image" tests: close the images and calibrate the images heap.

## [2.1.0] - 2023-02-06

### VEE Port Requirements

- MicroVG API 1.2
- VG Pack 1.2.1
- C Module MicroVG 2.1.0

### Added

- Add test to check the clip and the translation when drawing an image.
- Add test to check the "empty" drawings of a string.

### Fixed

- Make TestImageExternal and TestPath compatible with Android.
- Do not print debug logs in TestMatrix when the debug constant is not set.

## [2.0.1] - 2022-12-30

### VEE Port Requirements

- MicroVG API 1.2
- VG Pack 1.2.1
- C Module MicroVG 2.1.0

### Fixed

- TestBlendMode requires a non-null image heap size. 

## [2.0.0] - 2022-12-29

### VEE Port Requirements

- MicroVG API 1.2
- VG Pack 1.2.1
- C Module MicroVG 2.1.0

### Added

- Add a mechanism to run the full testsuite and a single test (in MicroEJ launch mode) using the same properties.
- Add test to check the side effects on Matrix.setConcat().
- Add tests for resource image closing.
- Add tests for external image loading.
- Add drawOnCircle tests with complex layouts.
- Add test with a very long path.
- Add more cases in blend mode test.

### Changed

- Close images in the color filter tests.
- Change test accuracy for Android (new pixel difference formula).
- Each test embeds only the necessary resources (not all the resources).

### Removed

- Remove the "wrong" vector image (no meaning with RAW format).

### Fixed

- Add missing clearScreen before FontExternal tests.
- Fix expected results for SRC and SRC_IN blend modes.
- Add tests for elapsed time outside the animated image duration.

## [1.1.0] - 2022-09-02

### VEE Port Requirements

- MicroVG API 1.1
- VG Pack 1.1.0
- C Module MicroVG 2.0.0

### Added

- Add test to check the use of external VectorFonts.
- Restore tests that close a VectorFont.
- Add test to check the use of VectorImageBuilder.
- Add test for complex text layout feature.
- Adjust some expected results to match Android specification.

### Changed

- Adapt drawStringOnCircle tests as character bboxes are joined at baseline.
  
## [1.0.0] - 2022-05-13

### VEE Port Requirements

- MicroVG API 1.0
- VG Pack 1.0.0

### Added

- Extract microvg-impl tests.
- Extract VectorFont tests.

---  
_Copyright 2022-2024 MicroEJ Corp. All rights reserved._\  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
