# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [14.2.0] - 2024-11-18

### Changed

- Move all tests that check the implementation over a GPU in the dedicated package `gpu`.
- Move the test `MicroejUiValidation` in the testsuite jar like all others tests.
- Use Junit 1.10.0 that allows to skip each test individually.

## [14.1.1] - 2024-10-17

### Changed

- Validate the UI Pack 14.1.1.

## [14.1.0] - 2024-10-09

### Changed

- Validate the UI Pack 14.1.0.

## [14.0.3] - 2024-10-01

### Fixed

- Fix the test `DisplayBufferRefresh.testDrawDisplay()` that could fail with a transmit and swap buffer policy.

## [1.8.2] - 2024-07-23

### Fixed

- Fix the test `Scale` to be more tolerant with some GPU (rendering of the anti-aliasing).

## [1.8.1] - 2024-04-11

### Changed

- Fetch the library `ej.library.test#benchmark-framework#2.0.1`.

## [1.8.0] - 2024-04-09

### Added

- Add a bench to check the VEE Port evolution.
- Add tests for buffer synchronization.

## [1.7.0] - 2024-02-14

### Added

- Add tests for buffer synchronization.
- Add tests for anti-aliased circle arc caps.

### Removed

- Cannot test flush bounds anymore (since UI Pack 14.0.0).

## [1.6.0] - 2023-12-21

### Added

- Add tests for anti-aliased arcs with a very small angles.
- Add tests for anti-aliased rectangles.

## [1.5.0] - 2023-11-30

### Added

- Add tests for the anti-aliasing of thick faded circles.

## [1.4.0] - 2023-10-23

### Added

- Add image format tests for pre-multiplied image formats.

### Changed

- Update the license.
- Make the assertion messages in FrameworkImage tests more detailed.

### Fixed

- Fix the size of the reference image for image transformation.

## [1.3.1] - 2023-09-20

### Fixed

- Print the reference coordinates when comparing with reference images.

## [1.3.0] - 2023-07-17

### Added

- Add the possibility to set the image heap size according to an expected number of framebuffers.
- Add tests that alternate the drawing destination.

### Fixed

- Fix the required image heap size for test "Screenshot": it depends on the framebuffer size.

## [1.2.0] - 2023-02-06

### Added

- Add tests for thick lines (with thickness larger than length).
- Add tests for drawing circles and ellipses with even diameter/axis lengths.
- Add tests for drawing full circle arcs.

## Fixed

- Fix the control image when debugging image comparisons.

## [1.1.0] - 2022-12-16

### Added

- Add image transformation tests.
- Add test to check the reset of the GPU clip.
- Add image format tests.
- Add ARGB8888 display test.
- Add display API tests.
- Add screenshot tests.
- Add tests that check that the flush bounds and clip are consistent.
- Add graphics context tests.
- Add drawing tests.
- Add shape tests.

### Changed

- Review the OverlapDisplayRegion test decoupling.

## [1.0.0] - 2022-09-01

### Added

- Add test to check the "end of flush" and "end of GPU drawing" concurrency.
- Add test to check the draw display region with overlapping.
- Add test to check the draw image region with overlapping.

---
_Copyright 2022-2024 MicroEJ Corp. All rights reserved._\
_Use of this source code is governed by a BSD-style license that can be found with this software._
