# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [5.0.1] - 2025-10-13

### Added
- New test override: `init.datems` can be set by testsuite runner to override default start date (2025-10-09).

### Changed
- Client auth certificates now generated with `extendedKeyUsage = critical, clientAuth`.
- `TestClientAuthentication_1` reverted to use a self-signed certificate (not a chain).
- Removed unnecessary inclusion of CA certs in test chains when CA is already deployed on validator side.
- Root CA changes:
  - Most client tests now use `server_root.crt` instead of `a_ca.crt`.
  - `TestServerNameIndication_*` now use `sni.crt` signed by `server_root`.
- `TestSSLServer*` behavior:
  - Server uses server certificate chain (`server`).
  - Remote side expects client certificate chain (`client2`) when client auth is enabled.

### Fixed
- Use monotonic clock (`ej.bon.Util.platformTimeMillis()`) for timeout tests.
- Regenerated CA certificates with `basicConstraints = critical, CA:TRUE` (X.509v3).
- Tests that authenticate server no longer add server cert to client's trust store; they now trust only the root CA, preventing chain-validation bypass..

### Removed
- Removed property `microej.ssl.testsuite.ssl.stack`. It's not necessary anymore to use separate resources for this stack.

## [5.0.0] - 2024-08-29

### Changed

 - Update certificates signed with an algorithm too weak for OpenSSL version 3 and higher: previously signed certificates with SHA1RSA are now signed with SHA256RSA.
 - Update RSA keys size from 1024 to 2048.
 - Update TLSv1 to TLSv1.2 in TestKeyStoreManipulation.
 - Update the initial test date in SSL utilities.
 - Upgrade net-ssl-2_2-testsuite-remote to version `2.0.0`.

## [4.0.2] - 2023-09-18

### Fixed

 - Remove useless Java vendor property check in SSLUtils.

## [4.0.1] - 2022-04-29

### Fixed

 - Set private-default conf for remote dependency.

## [4.0.0] - 2022-04-14

### Added

  - Add PKI tests.
  - Add the property `remote.machine.timeout` to configure remote application timeout.

### Changed

  - Increase the number of times the client-side of `TestPeerCloseSocketWrite` writes (Server-side doesn't close the socket fast enough).
  - Rename classes package and module.
  - Tests refactoring, properties renaming in order to avoid confusion and add Server Name Indication tests.

### Fixed

  - Remove tests that are not related to the SSL specification.

## [3.1.4] - 2021-05-07

### Fixed

  - Use different ports in ssl tests.
  - Use equals instead of matches to match the current test in init script files.

## [3.1.3] - 2021-04-08

### Fixed

  - Fix remote app initialization (`TestClientAuthentication_5`, `TestClientAuthentication_6`).

## [3.1.2] - 2020-09-08

### Fixed

  - Fix test misconfigured SNI test  (`TestClientAuthentication_6`).

## [3.1.1] - 2020-04-15

### Fixed

  - Update private keys for Mbed TLS.

## [3.1.0] - 2019-02-28

### Added

  - Add tests for TLS SNI feature (Server Name Indication).
  - Testsuite depends on `ej.api.ssl#2.2.+` including SSL/Security foundation libraries split.

### Fixed

  - SSL testsuite fail with error message on `remote.machine.hostname` property not set.

## [3.0.1] - 2018-09-24

### Fixed

  - SSL NonAutoClose test: the server is started twice instead of once and the second start causes a JVM_Bind exception.
  - Chain certificates are set with the same alias and only the last one is added as trusted.

## [3.0.0] - 2018-07-13

### Added

  - Increase the number of times the client-side of `TestPeerCloseSocketWrite` writes (Allow the test run through a VPN/NAT on Linux Virtual machine to work. Server-side doesn't close the socket fast enough).

### Fixed

  - The System current date of SSL test-suite is before the certificate "Not Before" date.

## [2.0.1] - 2017-10-27

### Added

  - Update SSL testsuite certificates which used the deprecated MD5 algorithm and use SHA1 algorithm instead.

## [2.0.0] - 2017-10-10

### Added

  - SSL ServerSocket tests.
  - Bidirectional SSL tests.
  - Add test `TestTrustWrongDateValidity` : Certificate validity check for identical subject (update of certificate validity dates).

## [1.4.0] - 2017-01-17

### Added

  - Add test `TestTrustOnlyFirstInChain`: Check TrustStore with multiple certificate and open connection using the first one.
  - Add test `TestPeerCloseSocketRead`: Check that write return end of file on peer socket close.
  - Add test `TestPeerCloseSocketWrite`: Check that write return connection reset on peer socket close.

## [1.3.0] - 2016-29-12

### Added

  - Update of the dependencies.

## [1.2.0] - 2016-01-11

### Added

  - Certificate chain validation implementation.

## [1.1.0] - 2015-12-31

### Added

  - TrustStore tests added.
  - SSL context automatic recycle tests added.

## [1.0.0] - 2015-12-07

### Added

  - Initial revision.

---

_Copyright 2022-2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
