# Overview

MicroEJ Foundation Library implementation: `net-1_1-testsuite-ethernet`.

Init service for Net testsuite using Ethernet connection.

As Net testsuite may need network initialization before running the tests, this library can be used if the device used for the testsuite is connected via Ethernet.

# Usage

## Properties

Some properties are needed to be defined by the user to initialize the network interface. These properties are:

- `netif.name`: Define the name of the network interface to initialize. This property is required.

- `netif.ip`: Define the static IP address to set for the network interface. If null, DHCP is used to automatically provide an IP address.

- `netif.netmask`: Define the netmask. (Used only if the static IP address is set with `netif.ip`).

- `netif.gateway`: Define the gateway. (Used only if the static IP address is set with `netif.ip`).

- `netif.dns`: Define a static DNS IP to be used.

## Dependencies

Add the following line to your `module.ivy`:

    <dependency org="com.microej.pack.net" name="net-1_1-testsuite-ethernet" rev="1.0.0"/>

# Requirements

This library requires the following Foundation Libraries:

    ECOM-NETWORK-2.0, EDC-1.3, NET-1.1

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---

_Copyright 2021-2022 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
