# Overview

The MicroEJ Foundation Library `SOAR` allows to generate a Feature object file (`.fo`) on Device. 
Then the `.fo` file can be dynamically linked using `KF` API `ej.kf.Kernel.install(InputStream)`.

It takes as input:
- the Kernel metadata (`application.kdat` file generated beside the Kernel `application.out`) 
- one or more Feature shared object files (`.fso`). 

The generated `.fo` file is compatible for the Kernel on which it is executed.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.api" name="soar" rev="1.0.0"/>
    
    
In a Kernel Application, 
- define an implementation of the `com.microej.soar.KernelMetadataProvider` interface. It is responsible to load Kernel metadata chunks . The way the Kernel metadata is loaded is specific to your Kernel Application and depends on the target Platform capabilities (File System, ...).
- create a `com.microej.soar.FeatureOptimizer(KernelMetadataProvider)` instance.
- use the `com.microej.soar.FeatureOptimizer.build(InputStream, OutputStream)` method to build one or more Feature object files (`.fo`) from Feature shared object files (`.fso`).

# Requirements

This library requires the following Foundation Libraries:

    EDC-1.3

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

This Foundation Library can only be used by a Kernel Application. 

---
_Markdown_  
_Copyright 2020-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
