/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package org.junit;

/**
 * An exception class used to implement <em>assumptions</em> (state in which a
 * given test is meaningful and should or should not be executed). A test for
 * which an assumption fails should not generate a test case failure.
 */
public class AssumptionViolatedException extends org.junit.internal.AssumptionViolatedException {

	private static final long serialVersionUID = 1L;

	/**
	 * An assumption exception with the given message only.
	 */
	public AssumptionViolatedException() {
		super();
	}

	/**
	 * An assumption exception with the given message and a cause.
	 */
	public AssumptionViolatedException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * An assumption exception with a message with the given actual value and a
	 * matcher describing the expectation that failed.
	 */
	public AssumptionViolatedException(String message) {
		super(message);
	}

	/**
	 * An assumption exception with the given actual value and a matcher describing
	 * the expectation that failed.
	 */
	public AssumptionViolatedException(Throwable cause) {
		super(cause);
	}

}
