/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothDescriptor</code> class represents a remote or a local GATT descriptor.
 * <p>
 * Remote descriptors may be retrieved from a Bluetooth device by {@link BluetoothDevice#discoverServices discovering
 * its services} and {@link BluetoothService#getCharacteristics getting their characteristics} and
 * {@link BluetoothCharacteristic#getDescriptors descriptors}.
 * <p>
 * Local descriptors may be created by using the {@link #BluetoothDescriptor class constructor} and
 * {@link BluetoothCharacteristic#addDescriptor added} to a local characteristic.
 * <p>
 * This class provides methods to get information on the descriptor.
 */
public class BluetoothDescriptor extends BluetoothAttribute {

	/**
	 * Creates a local descriptor with the given UUID and permissions.
	 * <p>
	 * This descriptor may then be {@link BluetoothCharacteristic#addDescriptor added} to a local characteristic.
	 *
	 * @param uuid
	 *            the descriptor UUID.
	 * @param permissions
	 *            the descriptor permissions (see {@link BluetoothPermissions}.
	 */
	public BluetoothDescriptor(BluetoothUuid uuid, int permissions) {
		throw new RuntimeException();
	}

	/**
	 * Returns the characteristic to which this descriptor belongs.
	 * <p>
	 * This method returns null if this is a local descriptor which has not been added to a characteristic.
	 *
	 * @return the descriptor to which this descriptor belongs.
	 */
	public BluetoothCharacteristic getCharacteristic() {
		throw new RuntimeException();
	}
}
