/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class SendNotificationCommand extends Command<Boolean> {

	private final short connHandle;
	private final short attributeHandle;
	private final byte[] value;
	private final int valueSize;
	private final boolean confirm;

	public SendNotificationCommand(short connHandle, short attributeHandle, byte[] value, int valueSize,
			boolean confirm) {
		this.connHandle = connHandle;
		this.attributeHandle = attributeHandle;
		this.value = value;
		this.valueSize = valueSize;
		this.confirm = confirm;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_NOTIFICATION;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
		sender.sendInt(this.attributeHandle);
		sender.sendByteArray(this.value, 0, this.valueSize);
		sender.sendBoolean(this.confirm);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
