/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class AddServiceCommand extends Command<Boolean> {

	private final byte[] service;
	private final int serviceSize;
	private final short[] handles;

	public AddServiceCommand(byte[] service, int serviceSize, short[] handles) {
		this.service = service;
		this.serviceSize = serviceSize;
		this.handles = handles;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_ADD_SERVICE;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendByteArray(this.service, 0, this.serviceSize);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		int numHandles = 1 + this.service[16] + this.service[17];

		boolean success = (reader.readInt() == Commands.OK);
		byte[] handlesByteArray = reader.readByteArray();

		for (int i = 0; i < numHandles; i++) {
			this.handles[i] = (short) ((handlesByteArray[i * 2] & 0xFF) << 8 | (handlesByteArray[i * 2 + 1] & 0xFF));
		}
		return Boolean.valueOf(success);
	}
}
