/*
 * Java
 *
 * Copyright 2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

import ej.bon.Constants;

/**
 * WARNING This class is a copy of the one available in the MicroUI
 * implementation jar available in UI Pack.
 *
 * Since UI pack 13.2.0, the MicroUI Graphics Engine integrates a set of methods
 * to obtain certain characteristics of the engine.
 */
public class DisplayUtilities {

	/**
	 * {@link Constants} value that indicates if the MicroUI Graphics Engine
	 * testsuite support is enabled. If enabled, the {@link DisplayUtilities} native
	 * methods can be called. Otherwise the c
	 */
	public static final String MICROUI_TESTSUITE_SUPPORT = "com.microej.microui.testsuite.support"; //$NON-NLS-1$

	private static final int FUNCTION_ID_GETNEXTFLUSHBOUNDS = 1;

	/**
	 * Gets the next flush bounds before calling the {@link Display#flush()}. These
	 * bounds are the values set by the Graphics Engine when calling
	 * "LLUI_DISPLAY_IMPL_flush()". This allows to check the drawing limits set by a
	 * drawing algorithm (see "bool LLUI_DISPLAY_setDrawingLimits(jint xmin, jint
	 * ymin, jint xmax, jint ymax);").
	 *
	 * The next flush bounds are the contenation of all drawings bounds made since
	 * last call to {@link Display#flush()}. To check specifically the drawing
	 * limits set by a given drawing algorithm, the test pattern is:
	 *
	 * <code>
	 * display.flush(); // flush and reset the flush bounds
	 * PainterXXX.drawXXX(gc, ...); // draw something; the drawing algorithm has to update the drawing limits
	 * DisplayUtilities.getNextFlushBounds(bounds); // get the current flush bounds == last drawing's limits
	 * AssertXXX(); // checks the limits
	 * </code>
	 *
	 * The given array will contains the next flush bounds: x1,y1,x2,y2. The array
	 * must be large enough (at least 4 elements).
	 *
	 * @param flushBounds
	 *            the array where store the newt flush bounds.
	 * @return true when the array has been filled, false on error (array too small,
	 *         etc.).
	 */
	public static boolean getNextFlushBounds(int[] flushBounds) {
		if (Constants.getBoolean(MICROUI_TESTSUITE_SUPPORT)
				&& !DisplayUtilitiesNatives.isDeprecated(FUNCTION_ID_GETNEXTFLUSHBOUNDS)) {
			return DisplayUtilitiesNatives.getNextFlushBounds(Display.getDisplay().getGraphicsContext().getSNIContext(),
					flushBounds);
		}
		throw new RuntimeException();
	}
}
