/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.net;

import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageBuilder;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Gather the messages.
 */
public final class ConnectivityMessages {
	// ****************//
	// Error messages. //
	// ****************//
	/**
	 * Unknown error.
	 */
	public static final int ERROR_UNKNOWN = -255;

	// ****************//
	// Info messages. //
	// ****************//

	/**
	 * Try connection.
	 */
	public static final int TRY = 1;

	/**
	 * Skipped.
	 */
	public static final int SKIP = 2;

	/**
	 * Category message.
	 */
	public static final String CATEGORY = "ConnectivityManager"; //$NON-NLS-1$

	/**
	 * The message builder.
	 */
	public static final MessageBuilder BUILDER = new BasicMessageBuilder();

	/**
	 * The message logger.
	 */
	public static final MessageLogger LOGGER = new BasicMessageLogger(BUILDER);



	private ConnectivityMessages() {
		// Forbid instantiation
	}
}
