/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothServiceDefinition</code> class represents the structure of a GATT service.
 * <p>
 * Service definitions may be created by using the {@link #BluetoothServiceDefinition(BluetoothUuid) class constructor}.
 * <p>
 * This class provides methods to add characteristics and descriptors to the service definition.
 */
public class BluetoothServiceDefinition {

	/**
	 * Creates a service definition.
	 *
	 * @param serviceUuid
	 *            the UUID of the service.
	 */
	public BluetoothServiceDefinition(BluetoothUuid serviceUuid) {
		throw new RuntimeException();
	}

	/**
	 * Adds a characteristic to this service definition.
	 *
	 * @param uuid
	 *            the UUID of the characteristic.
	 * @param properties
	 *            the properties of the characteristic (see {@link BluetoothProperties}.
	 * @param permissions
	 *            the permissions of the characteristic (see {@link BluetoothPermissions}.
	 */
	public void addCharacteristic(BluetoothUuid uuid, int properties, int permissions) {
		throw new RuntimeException();
	}

	/**
	 * Adds a descriptor to this service definition. The descriptor is attached to the last
	 * {@link #addCharacteristic(BluetoothUuid, int, int) characteristic added}.
	 *
	 * @param uuid
	 *            the UUID of the descriptor.
	 * @param permissions
	 *            the permissions of the descriptor (see {@link BluetoothPermissions}.
	 * @throws IllegalStateException
	 *             if no characteristic has been added before calling this method.
	 */
	public void addDescriptor(BluetoothUuid uuid, int permissions) {
		throw new RuntimeException();
	}
}
