package java.util;

import ej.annotation.Nullable;

/**
 * This class provides a skeletal implementation of the <tt>Map</tt> interface, to minimize the
 * effort required to implement this interface.
 *
 * <p>
 * To implement an unmodifiable map, the programmer needs only to extend this class and provide an
 * implementation for the <tt>entrySet</tt> method, which returns a set-view of the map's mappings.
 * Typically, the returned set will, in turn, be implemented atop <tt>AbstractSet</tt>. This set
 * should not support the <tt>add</tt> or <tt>remove</tt> methods, and its iterator should not
 * support the <tt>remove</tt> method.
 *
 * <p>
 * To implement a modifiable map, the programmer must additionally override this class's
 * <tt>put</tt> method (which otherwise throws an <tt>UnsupportedOperationException</tt>), and the
 * iterator returned by <tt>entrySet().iterator()</tt> must additionally implement its
 * <tt>remove</tt> method.
 *
 * <p>
 * The programmer should generally provide a void (no argument) and map constructor, as per the
 * recommendation in the <tt>Map</tt> interface specification.
 *
 * <p>
 * The documentation for each non-abstract method in this class describes its implementation in
 * detail. Each of these methods may be overridden if the map being implemented admits a more
 * efficient implementation.
 *
 * <p>
 * This class is a member of the Java Collections Framework
 *
 * @param <K>
 *        the type of keys maintained by this map
 * @param <V>
 *        the type of mapped values
 *
 * @see Map
 * @see Collection
 */
public abstract class AbstractMap<K, V> implements Map<K, V> {
	/**
	 * An Entry maintaining a key and a value. The value may be changed using the <tt>setValue</tt>
	 * method. This class facilitates the process of building custom map implementations. For example,
	 * it may be convenient to return arrays of <tt>SimpleEntry</tt> instances in method
	 * <tt>Map.entrySet().toArray</tt>.
	 */
	public static class SimpleEntry<K, V> implements Entry<K, V>, java.io.Serializable {

		/**
		 * Creates an entry representing the same mapping as the specified entry.
		 *
		 * @param entry
		 *        the entry to copy
		 */
		public SimpleEntry(Entry<? extends K, ? extends V> entry) {
			throw new RuntimeException();
		}

		/**
		 * Creates an entry representing a mapping from the specified key to the specified value.
		 *
		 * @param key
		 *        the key represented by this entry
		 * @param value
		 *        the value represented by this entry
		 */
		public SimpleEntry(K key, V value) {
			throw new RuntimeException();
		}

		/**
		 * Compares the specified object with this entry for equality. Returns {@code true} if the given
		 * object is also a map entry and the two entries represent the same mapping. More formally, two
		 * entries {@code e1} and {@code e2} represent the same mapping if
		 *
		 * <pre>
		 * (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey()))
		 * 		&amp;&amp; (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()))
		 * </pre>
		 *
		 * This ensures that the {@code equals} method works properly across different implementations of
		 * the {@code Map.Entry} interface.
		 *
		 * @param o
		 *        object to be compared for equality with this map entry
		 * @return {@code true} if the specified object is equal to this map entry
		 * @see #hashCode
		 */
		@Override
		public boolean equals(@Nullable Object o) {
			throw new RuntimeException();
		}

		/**
		 * Returns the key corresponding to this entry.
		 *
		 * @return the key corresponding to this entry
		 */
		@Override
		public K getKey() {
			throw new RuntimeException();
		}

		/**
		 * Returns the value corresponding to this entry.
		 *
		 * @return the value corresponding to this entry
		 */
		@Override
		public V getValue() {
			throw new RuntimeException();
		}

		/**
		 * Returns the hash code value for this map entry. The hash code of a map entry {@code e} is defined
		 * to be:
		 *
		 * <pre>
		 * (e.getKey() == null ? 0 : e.getKey().hashCode()) &circ; (e.getValue() == null ? 0 : e.getValue().hashCode())
		 * </pre>
		 *
		 * This ensures that {@code e1.equals(e2)} implies that {@code e1.hashCode()==e2.hashCode()} for any
		 * two Entries {@code e1} and {@code e2}, as required by the general contract of
		 * {@link Object#hashCode}.
		 *
		 * @return the hash code value for this map entry
		 * @see #equals
		 */
		@Override
		public int hashCode() {
			throw new RuntimeException();
		}

		/**
		 * Replaces the value corresponding to this entry with the specified value.
		 *
		 * @param value
		 *        new value to be stored in this entry
		 * @return the old value corresponding to the entry
		 */
		@Override
		public V setValue(V value) {
			throw new RuntimeException();
		}

		/**
		 * Returns a String representation of this map entry. This implementation returns the string
		 * representation of this entry's key followed by the equals character ("<tt>=</tt>") followed by
		 * the string representation of this entry's value.
		 *
		 * @return a String representation of this map entry
		 */
		@Override
		public String toString() {
			throw new RuntimeException();
		}

	}

	/**
	 * An Entry maintaining an immutable key and value. This class does not support method
	 * <tt>setValue</tt>. This class may be convenient in methods that return thread-safe snapshots of
	 * key-value mappings.
	 */
	public static class SimpleImmutableEntry<K, V> implements Entry<K, V>, java.io.Serializable {

		/**
		 * Creates an entry representing the same mapping as the specified entry.
		 *
		 * @param entry
		 *        the entry to copy
		 */
		public SimpleImmutableEntry(Entry<? extends K, ? extends V> entry) {
			throw new RuntimeException();
		}

		/**
		 * Creates an entry representing a mapping from the specified key to the specified value.
		 *
		 * @param key
		 *        the key represented by this entry
		 * @param value
		 *        the value represented by this entry
		 */
		public SimpleImmutableEntry(K key, V value) {
			throw new RuntimeException();
		}

		/**
		 * Compares the specified object with this entry for equality. Returns {@code true} if the given
		 * object is also a map entry and the two entries represent the same mapping. More formally, two
		 * entries {@code e1} and {@code e2} represent the same mapping if
		 *
		 * <pre>
		 * (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey()))
		 * 		&amp;&amp; (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()))
		 * </pre>
		 *
		 * This ensures that the {@code equals} method works properly across different implementations of
		 * the {@code Map.Entry} interface.
		 *
		 * @param o
		 *        object to be compared for equality with this map entry
		 * @return {@code true} if the specified object is equal to this map entry
		 * @see #hashCode
		 */
		@Override
		public boolean equals(@Nullable Object o) {
			throw new RuntimeException();
		}

		/**
		 * Returns the key corresponding to this entry.
		 *
		 * @return the key corresponding to this entry
		 */
		@Override
		public K getKey() {
			throw new RuntimeException();
		}

		/**
		 * Returns the value corresponding to this entry.
		 *
		 * @return the value corresponding to this entry
		 */
		@Override
		public V getValue() {
			throw new RuntimeException();
		}

		/**
		 * Returns the hash code value for this map entry. The hash code of a map entry {@code e} is defined
		 * to be:
		 *
		 * <pre>
		 * (e.getKey() == null ? 0 : e.getKey().hashCode()) &circ; (e.getValue() == null ? 0 : e.getValue().hashCode())
		 * </pre>
		 *
		 * This ensures that {@code e1.equals(e2)} implies that {@code e1.hashCode()==e2.hashCode()} for any
		 * two Entries {@code e1} and {@code e2}, as required by the general contract of
		 * {@link Object#hashCode}.
		 *
		 * @return the hash code value for this map entry
		 * @see #equals
		 */
		@Override
		public int hashCode() {
			throw new RuntimeException();
		}

		/**
		 * Replaces the value corresponding to this entry with the specified value (optional operation).
		 * This implementation simply throws <tt>UnsupportedOperationException</tt>, as this class
		 * implements an <i>immutable</i> map entry.
		 *
		 * @param value
		 *        new value to be stored in this entry
		 * @return (Does not return)
		 * @throws UnsupportedOperationException
		 *         always
		 */
		@Override
		public V setValue(V value) {
			throw new RuntimeException();
		}

		/**
		 * Returns a String representation of this map entry. This implementation returns the string
		 * representation of this entry's key followed by the equals character ("<tt>=</tt>") followed by
		 * the string representation of this entry's value.
		 *
		 * @return a String representation of this map entry
		 */
		@Override
		public String toString() {
			throw new RuntimeException();
		}

	}

	/**
	 * Sole constructor. (For invocation by subclass constructors, typically implicit.)
	 */
	protected AbstractMap() {
	}

	/**
	 * Removes all of the mappings from this map (optional operation). The map will be empty after this
	 * call returns.
	 *
	 * <p>
	 * This implementation calls <tt>entrySet().clear()</tt>.
	 *
	 * <p>
	 * Note that this implementation throws an <tt>UnsupportedOperationException</tt> if the
	 * <tt>entrySet</tt> does not support the <tt>clear</tt> operation.
	 *
	 * @throws UnsupportedOperationException
	 *         if the <tt>clear</tt> operation is not supported by this map
	 */
	@Override
	public void clear() {
		throw new RuntimeException();
	}

	/**
	 * Returns a shallow copy of this <tt>AbstractMap</tt> instance: the keys and values themselves are
	 * not cloned.
	 *
	 * @return a shallow copy of this map
	 */
	@Override
	protected Object clone() throws CloneNotSupportedException {
		throw new RuntimeException();
	}

	/**
	 * Returns <tt>true</tt> if this map contains a mapping for the specified key. More formally,
	 * returns <tt>true</tt> if and only if this map contains a mapping for a key <tt>k</tt> such that
	 * <tt>(key==null ? k==null : key.equals(k))</tt>. (There can be at most one such mapping.)
	 *
	 * <p>
	 * This implementation iterates over <tt>entrySet()</tt> searching for an entry with the specified
	 * key. If such an entry is found, <tt>true</tt> is returned. If the iteration terminates without
	 * finding such an entry, <tt>false</tt> is returned. Note that this implementation requires linear
	 * time in the size of the map; many implementations will override this method.
	 *
	 * @param key
	 *        key whose presence in this map is to be tested
	 * @return <tt>true</tt> if this map contains a mapping for the specified key
	 * @throws ClassCastException
	 *         if the key is of an inappropriate type for this map
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified key is null and this map does not permit null keys
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 */
	@Override
	public boolean containsKey(Object key) {
		throw new RuntimeException();
	}

	/**
	 * Returns <tt>true</tt> if this map maps one or more keys to the specified value. More formally,
	 * returns <tt>true</tt> if and only if this map contains at least one mapping to a value <tt>v</tt>
	 * such that <tt>(value==null ? v==null : value.equals(v))</tt>. This operation will probably
	 * require time linear in the map size for most implementations of the <tt>Map</tt> interface.
	 *
	 * <p>
	 * This implementation iterates over <tt>entrySet()</tt> searching for an entry with the specified
	 * value. If such an entry is found, <tt>true</tt> is returned. If the iteration terminates without
	 * finding such an entry, <tt>false</tt> is returned. Note that this implementation requires linear
	 * time in the size of the map.
	 *
	 * @param value
	 *        value whose presence in this map is to be tested
	 * @return <tt>true</tt> if this map maps one or more keys to the specified value
	 * @throws ClassCastException
	 *         if the value is of an inappropriate type for this map
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified value is null and this map does not permit null values
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 */
	@Override
	public boolean containsValue(Object value) {
		throw new RuntimeException();
	}

	@Override
	public abstract Set<Entry<K, V>> entrySet();

	/**
	 * Compares the specified object with this map for equality. Returns <tt>true</tt> if the given
	 * object is also a map and the two maps represent the same mappings. More formally, two maps
	 * <tt>m1</tt> and <tt>m2</tt> represent the same mappings if
	 * <tt>m1.entrySet().equals(m2.entrySet())</tt>. This ensures that the <tt>equals</tt> method works
	 * properly across different implementations of the <tt>Map</tt> interface.
	 *
	 * <p>
	 * This implementation first checks if the specified object is this map; if so it returns
	 * <tt>true</tt>. Then, it checks if the specified object is a map whose size is identical to the
	 * size of this map; if not, it returns <tt>false</tt>. If so, it iterates over this map's
	 * <tt>entrySet</tt> collection, and checks that the specified map contains each mapping that this
	 * map contains. If the specified map fails to contain such a mapping, <tt>false</tt> is returned.
	 * If the iteration completes, <tt>true</tt> is returned.
	 *
	 * @param o
	 *        object to be compared for equality with this map
	 * @return <tt>true</tt> if the specified object is equal to this map
	 */
	@Override
	public boolean equals(@Nullable Object o) {
		throw new RuntimeException();
	}

	/**
	 * Returns the value to which the specified key is mapped, or {@code null} if this map contains no
	 * mapping for the key.
	 *
	 * <p>
	 * More formally, if this map contains a mapping from a key {@code k} to a value {@code v} such that
	 * {@code (key==null ? k==null :
	 * key.equals(k))}, then this method returns {@code v}; otherwise it returns {@code null}. (There
	 * can be at most one such mapping.)
	 *
	 * <p>
	 * If this map permits null values, then a return value of {@code null} does not <i>necessarily</i>
	 * indicate that the map contains no mapping for the key; it's also possible that the map explicitly
	 * maps the key to {@code null}. The {@link #containsKey containsKey} operation may be used to
	 * distinguish these two cases.
	 *
	 * <p>
	 * This implementation iterates over <tt>entrySet()</tt> searching for an entry with the specified
	 * key. If such an entry is found, the entry's value is returned. If the iteration terminates
	 * without finding such an entry, <tt>null</tt> is returned. Note that this implementation requires
	 * linear time in the size of the map; many implementations will override this method.
	 *
	 * @param key
	 *        the key whose associated value is to be returned
	 * @return the value to which the specified key is mapped, or {@code null} if this map contains no
	 *         mapping for the key
	 * @throws ClassCastException
	 *         if the key is of an inappropriate type for this map
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified key is null and this map does not permit null keys
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 */
	@Override
	@Nullable
	public V get(Object key) {
		throw new RuntimeException();
	}

	/**
	 * Returns the hash code value for this map. The hash code of a map is defined to be the sum of the
	 * hash codes of each entry in the map's <tt>entrySet()</tt> view. This ensures that
	 * <tt>m1.equals(m2)</tt> implies that <tt>m1.hashCode()==m2.hashCode()</tt> for any two maps
	 * <tt>m1</tt> and <tt>m2</tt>, as required by the general contract of {@link Object#hashCode}.
	 *
	 * <p>
	 * This implementation iterates over <tt>entrySet()</tt>, calling {@link Map.Entry#hashCode
	 * hashCode()} on each element (entry) in the set, and adding up the results.
	 *
	 * @return the hash code value for this map
	 * @see Map.Entry#hashCode()
	 * @see Object#equals(Object)
	 * @see Set#equals(Object)
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns <tt>true</tt> if this map contains no key-value mappings.
	 *
	 * <p>
	 * This implementation returns <tt>size() == 0</tt>.
	 *
	 * @return <tt>true</tt> if this map contains no key-value mappings
	 */
	@Override
	public boolean isEmpty() {
		throw new RuntimeException();
	}

	/**
	 * Returns a {@link Set} view of the keys contained in this map. The set is backed by the map, so
	 * changes to the map are reflected in the set, and vice-versa. If the map is modified while an
	 * iteration over the set is in progress (except through the iterator's own <tt>remove</tt>
	 * operation), the results of the iteration are undefined. The set supports element removal, which
	 * removes the corresponding mapping from the map, via the <tt>Iterator.remove</tt>,
	 * <tt>Set.remove</tt>, <tt>removeAll</tt>, <tt>retainAll</tt>, and <tt>clear</tt> operations. It
	 * does not support the <tt>add</tt> or <tt>addAll</tt> operations.
	 *
	 * <p>
	 * This implementation returns a set that subclasses {@link AbstractSet}. The subclass's iterator
	 * method returns a "wrapper object" over this map's <tt>entrySet()</tt> iterator. The <tt>size</tt>
	 * method delegates to this map's <tt>size</tt> method and the <tt>contains</tt> method delegates to
	 * this map's <tt>containsKey</tt> method.
	 *
	 * <p>
	 * The set is created the first time this method is called, and returned in response to all
	 * subsequent calls. No synchronization is performed, so there is a slight chance that multiple
	 * calls to this method will not all return the same set.
	 *
	 * @return a set view of the keys contained in this map
	 */
	@Override
	public Set<K> keySet() {
		throw new RuntimeException();
	}

	/**
	 * Associates the specified value with the specified key in this map (optional operation). If the
	 * map previously contained a mapping for the key, the old value is replaced by the specified value.
	 * (A map <tt>m</tt> is said to contain a mapping for a key <tt>k</tt> if and only if
	 * {@link #containsKey(Object) m.containsKey(k)} would return <tt>true</tt>.)
	 *
	 * <p>
	 * This implementation always throws an <tt>UnsupportedOperationException</tt>.
	 *
	 * @param key
	 *        key with which the specified value is to be associated
	 * @param value
	 *        value to be associated with the specified key
	 * @return the previous value associated with <tt>key</tt>, or <tt>null</tt> if there was no mapping
	 *         for <tt>key</tt>. (A <tt>null</tt> return can also indicate that the map previously
	 *         associated <tt>null</tt> with <tt>key</tt>, if the implementation supports <tt>null</tt>
	 *         values.)
	 * @throws UnsupportedOperationException
	 *         if the <tt>put</tt> operation is not supported by this map
	 * @throws ClassCastException
	 *         if the class of the specified key or value prevents it from being stored in this map
	 * @throws NullPointerException
	 *         if the specified key or value is null and this map does not permit null keys or values
	 * @throws IllegalArgumentException
	 *         if some property of the specified key or value prevents it from being stored in this map
	 */
	@Override
	@Nullable
	public V put(K key, V value) {
		throw new RuntimeException();
	}

	/**
	 * Copies all of the mappings from the specified map to this map (optional operation). The effect of
	 * this call is equivalent to that of calling {@link #put(Object,Object) put(k, v)} on this map once
	 * for each mapping from key <tt>k</tt> to value <tt>v</tt> in the specified map. The behavior of
	 * this operation is undefined if the specified map is modified while the operation is in progress.
	 *
	 * <p>
	 * This implementation iterates over the specified map's <tt>entrySet()</tt> collection, and calls
	 * this map's <tt>put</tt> operation once for each entry returned by the iteration.
	 *
	 * <p>
	 * Note that this implementation throws an <tt>UnsupportedOperationException</tt> if this map does
	 * not support the <tt>put</tt> operation and the specified map is nonempty.
	 *
	 * @param m
	 *        mappings to be stored in this map
	 * @throws UnsupportedOperationException
	 *         if the <tt>putAll</tt> operation is not supported by this map
	 * @throws ClassCastException
	 *         if the class of a key or value in the specified map prevents it from being stored in this
	 *         map
	 * @throws NullPointerException
	 *         if the specified map is null, or if this map does not permit null keys or values, and the
	 *         specified map contains null keys or values
	 * @throws IllegalArgumentException
	 *         if some property of a key or value in the specified map prevents it from being stored in
	 *         this map
	 */
	@Override
	public void putAll(Map<? extends K, ? extends V> m) {
		throw new RuntimeException();
	}

	/**
	 * Removes the mapping for a key from this map if it is present (optional operation). More formally,
	 * if this map contains a mapping from key <tt>k</tt> to value <tt>v</tt> such that
	 * <code>(key==null ?  k==null : key.equals(k))</code>, that mapping is removed. (The map can
	 * contain at most one such mapping.)
	 *
	 * <p>
	 * Returns the value to which this map previously associated the key, or <tt>null</tt> if the map
	 * contained no mapping for the key.
	 *
	 * <p>
	 * If this map permits null values, then a return value of <tt>null</tt> does not <i>necessarily</i>
	 * indicate that the map contained no mapping for the key; it's also possible that the map
	 * explicitly mapped the key to <tt>null</tt>.
	 *
	 * <p>
	 * The map will not contain a mapping for the specified key once the call returns.
	 *
	 * <p>
	 * This implementation iterates over <tt>entrySet()</tt> searching for an entry with the specified
	 * key. If such an entry is found, its value is obtained with its <tt>getValue</tt> operation, the
	 * entry is removed from the collection (and the backing map) with the iterator's <tt>remove</tt>
	 * operation, and the saved value is returned. If the iteration terminates without finding such an
	 * entry, <tt>null</tt> is returned. Note that this implementation requires linear time in the size
	 * of the map; many implementations will override this method.
	 *
	 * <p>
	 * Note that this implementation throws an <tt>UnsupportedOperationException</tt> if the
	 * <tt>entrySet</tt> iterator does not support the <tt>remove</tt> method and this map contains a
	 * mapping for the specified key.
	 *
	 * @param key
	 *        key whose mapping is to be removed from the map
	 * @return the previous value associated with <tt>key</tt>, or <tt>null</tt> if there was no mapping
	 *         for <tt>key</tt>.
	 * @throws UnsupportedOperationException
	 *         if the <tt>remove</tt> operation is not supported by this map
	 * @throws ClassCastException
	 *         if the key is of an inappropriate type for this map
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 * @throws NullPointerException
	 *         if the specified key is null and this map does not permit null keys
	 *         (<a href="Collection.html#optional-restrictions">optional</a>)
	 */
	@Override
	@Nullable
	public V remove(Object key) {
		throw new RuntimeException();
	}

	/**
	 * Returns the number of key-value mappings in this map. If the map contains more than
	 * <tt>Integer.MAX_VALUE</tt> elements, returns <tt>Integer.MAX_VALUE</tt>.
	 *
	 * <p>
	 * This implementation returns <tt>entrySet().size()</tt>.
	 *
	 * @return the number of key-value mappings in this map
	 */
	@Override
	public int size() {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this map. The string representation consists of a list of
	 * key-value mappings in the order returned by the map's <tt>entrySet</tt> view's iterator, enclosed
	 * in braces (<tt>"{}"</tt>). Adjacent mappings are separated by the characters <tt>", "</tt> (comma
	 * and space). Each key-value mapping is rendered as the key followed by an equals sign
	 * (<tt>"="</tt>) followed by the associated value. Keys and values are converted to strings as by
	 * {@link String#valueOf(Object)}.
	 *
	 * @return a string representation of this map
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Returns a {@link Collection} view of the values contained in this map. The collection is backed
	 * by the map, so changes to the map are reflected in the collection, and vice-versa. If the map is
	 * modified while an iteration over the collection is in progress (except through the iterator's own
	 * <tt>remove</tt> operation), the results of the iteration are undefined. The collection supports
	 * element removal, which removes the corresponding mapping from the map, via the
	 * <tt>Iterator.remove</tt>, <tt>Collection.remove</tt>, <tt>removeAll</tt>, <tt>retainAll</tt> and
	 * <tt>clear</tt> operations. It does not support the <tt>add</tt> or <tt>addAll</tt> operations.
	 *
	 * <p>
	 * This implementation returns a collection that subclasses {@link AbstractCollection}. The
	 * subclass's iterator method returns a "wrapper object" over this map's <tt>entrySet()</tt>
	 * iterator. The <tt>size</tt> method delegates to this map's <tt>size</tt> method and the
	 * <tt>contains</tt> method delegates to this map's <tt>containsValue</tt> method.
	 *
	 * <p>
	 * The collection is created the first time this method is called, and returned in response to all
	 * subsequent calls. No synchronization is performed, so there is a slight chance that multiple
	 * calls to this method will not all return the same collection.
	 *
	 * @return a collection view of the values contained in this map
	 */
	@Override
	public Collection<V> values() {
		throw new RuntimeException();
	}

}
