/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2018 IS2T - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.security.spec;

/**
 * This class represents a public or private key in encoded format.
 *
 * @author Jan Luehe
 *
 *
 * @see java.security.Key
 * @see java.security.KeyFactory
 * @see KeySpec
 * @see PKCS8EncodedKeySpec
 *
 * @since 1.2
 */

public abstract class EncodedKeySpec implements KeySpec {

	/**
	 * Creates a new EncodedKeySpec with the given encoded key.
	 *
	 * @param encodedKey
	 *            the encoded key. The contents of the array are copied to protect against subsequent modification.
	 * @exception NullPointerException
	 *                if {@code encodedKey} is null.
	 */
	public EncodedKeySpec(byte[] encodedKey) {
		throw new RuntimeException();
	}

	/**
	 * Returns the encoded key.
	 *
	 * @return the encoded key. Returns a new array each time this method is called.
	 */
	public byte[] getEncoded() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the encoding format associated with this key specification.
	 *
	 * <p>
	 * If the opaque representation of a key (see {@link java.security.Key Key}) can be transformed (see
	 * {@link java.security.KeyFactory KeyFactory}) into this key specification (or a subclass of it), {@code getFormat}
	 * called on the opaque key returns the same value as the {@code getFormat} method of this key specification.
	 *
	 * @return a string representation of the encoding format.
	 */
	public abstract String getFormat();
}
