/*
 * Java
 *
 * 2010-2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.event.generator;

import ej.microui.display.Display;

/**
 * A pointer event generator represents a pointing device that is usually associated to a group of physical buttons. It
 * reports the position of a pointing device as an x, y position within an area called pointer area. The size of the
 * pointer area is set when the pointer is constructed and cannot be modified. When a pointer is pre-configured within a
 * system its area is normally set to be the area of the {@link Display} with which it is associated. The associated
 * MicroUI event type is {@link #EVENT_TYPE}.<br>
 * <p>
 * The pointer can be asked for the absolute position, expressed in terms of the pointer area with which it was
 * constructed. It can also be asked for scaled co-ordinates ({@link #getX()}, {@link #getY()}). The scaled area is set
 * using the {@link #setScale(int, int)} method. By default there is no scaling (scaled area is the pointer area).<br>
 * <p>
 * It is also possible to specify, using {@link #setOrigin(int, int)}, an offset to be applied to the co-ordinates
 * returned by <code>getX()</code> and <code>getX()</code>. For example, if the origin is set to be
 * <code>(20, 30)</code> then the x position returned will be the absolute x position - 20, and the y position will be
 * the absolute y position - 30. By default there is no offset.<br>
 * <p>
 * If both scaling and origin adjustment are specified then the origin offset is first applied to the absolute position
 * then the scaling is applied.<br>
 */
public class Pointer extends Buttons {

	/**
	 * The POINTER event type returned by {@link #getEventType()}.
	 */
	public static final int EVENT_TYPE = 0x02;

	/**
	 * Constant for "moved" action.
	 */
	public static final int MOVED = 0x06;

	/**
	 * Constant for "dragged" action.
	 */
	public static final int DRAGGED = 0x07;

	/**
	 * Constructor with a specified area range (<code>width</code> and <code>height</code>) where elapsedTime, click and
	 * doubleClick features are supported and enabled for the first <code>nbButtons</code> (doubleClick feature is
	 * initialized with a 200ms delay).
	 *
	 * @param nbButtons
	 *            the number of buttons that support the extended features
	 * @param width
	 *            area width
	 * @param height
	 *            area height
	 */
	public Pointer(int nbButtons, int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Constructor with a specified area range (<code>width</code> and <code>height</code>) that does not support click,
	 * doubleClick nor elapsedTime for any of its buttons. The effect is identical to:<br>
	 * <code>new Pointer(0, width, height)</code>.
	 *
	 * @param width
	 *            area width
	 * @param height
	 *            area height
	 */
	public Pointer(int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * @return pointer area width
	 */
	public int getAbsoluteWidth() {
		throw new RuntimeException();
	}

	/**
	 * @return pointer area height
	 */
	public int getAbsoluteHeight() {
		throw new RuntimeException();
	}

	/**
	 * Gets the event type associated with the event generator. Default value is {@link #EVENT_TYPE}.
	 *
	 * @return the event type
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Returns the last available x coordinate in scaled area (after applying any origin offset and the scale factor).
	 *
	 * @return last available x coordinate
	 * @see #getAbsoluteX()
	 */
	public int getX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the last available y coordinate in scaled area (after applying any origin offset and the scale factor).
	 *
	 * @return last available y coordinate
	 * @see #getAbsoluteY()
	 */
	public int getY() {
		throw new RuntimeException();
	}

	/**
	 * Returns the last available absolute x coordinate in pointer area
	 *
	 * @return last available absolute x coordinate
	 */
	public int getAbsoluteX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the last available absolute y coordinate in pointer area
	 *
	 * @return last available absolute y coordinate
	 */
	public int getAbsoluteY() {
		throw new RuntimeException();
	}

	/**
	 * Sets a scaled area. The x position returned by {@link #getX()} is scaled so that it returns a value between 0 and
	 * areaWidth-1. The x position returned by {@link #getY()} is scaled so that it returns a value between 0 and
	 * areaHeight-1.
	 *
	 * @param areaWidth
	 *            the area width
	 * @param areaHeight
	 *            the area height
	 */
	public void setScale(int areaWidth, int areaHeight) {
		throw new RuntimeException();
	}

	/**
	 * Sets an origin offset. This offset is subtracted from the absolute position (before applying any scaling) when
	 * reporting x and y positions.
	 *
	 * @param x0
	 *            the X coordinate of the new origin
	 * @param y0
	 *            the Y coordinate of the new origin
	 */
	public void setOrigin(int x0, int y0) {
		throw new RuntimeException();
	}

	/**
	 * @return the width of the scaled area
	 * @see #getX()
	 */
	public int getWidth() {
		throw new RuntimeException();
	}

	/**
	 * @return the height of the scaled area
	 * @see #getY()
	 */
	public int getHeight() {
		throw new RuntimeException();
	}

	/**
	 * Stores the given position and sends a MicroUI Event to the Pointer's listener. Coordinates are clipped to the
	 * pointer area.
	 *
	 * @param x
	 *            the x coordinate
	 * @param y
	 *            the y coordinate
	 */
	public void move(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Stores the given position. The Pointer's listener is not notified. Coordinates are clipped to the pointer area.
	 *
	 * @param x
	 *            the x coordinate
	 * @param y
	 *            the y coordinate
	 */
	public void reset(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Sends a MicroUI event for the given action on given button to the listener of the Pointer. Pointer will generate
	 * a {@link #CLICKED} and/or {@link #DOUBLE_CLICKED} events if the matching button's feature is enabled.<br>
	 * <p>
	 * This method is useful when other input mechanisms wish to simulate button actions.
	 *
	 * @param action
	 *            the button's action: {@link #PRESSED}, {@link #RELEASED}, {@link #LONG}, {@link #REPEATED}.
	 * @param buttonId
	 *            the button on which the action occurred
	 */

	@Override
	public void send(int action, int buttonId) {
		throw new RuntimeException();
	}

	/**
	 * Tells if a pointer event is a move event.
	 *
	 * @param event
	 *            the pointer event.
	 * @return true if the pointer event is a move event.
	 */
	public static boolean isMoved(int event) {
		throw new RuntimeException();
	}

	/**
	 * Tells if a pointer event is a drag event.
	 *
	 * @param event
	 *            the pointer event.
	 * @return true if the pointer event is a drag event.
	 */
	public static boolean isDragged(int event) {
		throw new RuntimeException();
	}
}
