/*
 * Java
 *
 * 2012-2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.event.generator;

import ej.microui.event.EventGenerator;

/**
 * Generic event generator.
 * <p>
 * Generic communication to receive events.
 * 
 * @since 2.0
 */
public abstract class GenericEventGenerator extends EventGenerator {

	/**
	 * Called at startup to configure the event generator with the specific properties set in the .microui file.
	 *
	 * @param name
	 *            the property name
	 * @param value
	 *            the property value
	 */
	public abstract void setProperty(String name, String value);

	/**
	 * Called by MicroUI framework when a custom event has been received from native world. The current custom event
	 * contains only one 32-bit value.
	 *
	 * @param event
	 *            the 32-bit custom event value.
	 */
	protected abstract void eventReceived(int event);

	/**
	 * Called by MicroUI framework when a custom event has been received from native world. The current custom event
	 * contains several 32-bit values.
	 *
	 * @param events
	 *            the 32-bit custom event values.
	 */
	protected abstract void eventsReceived(int[] events);
}
