/*
 * Java
 *
 * Copyright 2017-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package ej.junit;

public interface TestListener {

	void testSuiteStarted(String name);

	void testBeforeClassMethod(String testClass, String methodName);

	void testInstance(String testClass);

	void testBeforeMethod(String testClass, String methodName);

	void testStarted(String testClass, String testMethod);

	void testSuccess(String testClass, String testMethod, long duration);

	void testFailure(String testClass, String testMethod, long duration, Throwable error, String errorMessage);

	void testError(String testClass, String testMethod, long duration, Throwable error, String errorMessage);

	void testAfterMethod(String testClass, String methodName);

	void testAfterClassMethod(String testClass, String methodName);

	void testSuiteEnded(String name, int runs, int failures, int errors);

}
