/*
 * Java
 *
 * Copyright 2017-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package ej.junit;

public class CheckHelperTestListener implements TestListener {

	private final boolean verbose = Boolean.getBoolean("ej.junit.checkhelper.verbose");

	@Override
	public void testSuiteStarted(String name) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running testsuite: " + name);
		}
	}

	@Override
	public void testBeforeClassMethod(String testClass, String methodName) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running @BeforeClass method: " + methodName);
		}
	}

	@Override
	public void testInstance(String testClass) {
		if (this.verbose) {
			System.err.println("[JUNIT] Instantiating: " + testClass);
		}
	}

	@Override
	public void testBeforeMethod(String testClass, String methodName) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running @Before method: " + methodName);
		}
	}

	@Override
	public void testStarted(String testClass, String testMethod) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running method: " + testMethod);
		}
	}

	@Override
	public void testSuccess(String testClass, String testMethod, long duration) {
		System.err.println("OK: " + testMethod);
	}

	@Override
	public void testFailure(String testClass, String testMethod, long duration, Throwable error, String errorMessage) {
		if (errorMessage != null) {
			System.err.println("KO: " + testMethod + " Assertion failed: " + errorMessage);
		} else {
			System.err.println("KO: " + testMethod + " Assertion failed");
		}
		if (error != null) {
			error.printStackTrace(System.err);
		}
	}

	@Override
	public void testError(String testClass, String testMethod, long duration, Throwable error, String errorMessage) {
		if (errorMessage != null) {
			System.err.println("KO: Unexpected error when running " + testMethod + ", message = " + errorMessage);
		} else {
			if (error != null) {
				System.err.println("KO: Unexpected error when running " + testMethod + ", error = " + error);
			} else {
				System.err.println("KO: Unexpected error when running " + testMethod);
			}
		}
		if (error != null) {
			error.printStackTrace(System.err);
		}
	}

	@Override
	public void testAfterMethod(String testClass, String methodName) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running @After method: " + methodName);
		}
	}

	@Override
	public void testAfterClassMethod(String testClass, String methodName) {
		if (this.verbose) {
			System.err.println("[JUNIT] Running @AfterClass method: " + methodName);
		}
	}

	@Override
	public void testSuiteEnded(String name, int runs, int failures, int errors) {
		if (this.verbose) {
			System.err.println("[JUNIT] testsuite ended: " + name);
		}
		if (failures > 0 || errors > 0) {
			System.err.println("FAILED: " + failures + " failures, " + errors + " errors, out of " + runs + " runs.");
		} else {
			System.err.println("PASSED: " + runs);
		}
	}
}
