/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

import ej.microui.event.generator.Pointer;

/**
 * The <code>FlyingImage</code> class defines an image to be displayed at the top level in the rendering depth of a
 * display.<br>
 * <br>
 * A <code>FlyingImage</code> contains an <code>Image</code>. This image associates the <code>FlyingImage</code> with a
 * specific display (since an <code>Image</code> is created for a specific display).<br>
 * Several <code>FlyingImage</code> objects may be associated with a <code>Display</code>. The flying images of an
 * application are drawn above all drawings coming from the standard <code>paint()</code> calls. Flying images are drawn
 * on a display in the order they are shown: The flying image drawn on top of the display is the last shown (it is above
 * all the other drawings) <br>
 * <br>
 *
 * @see Pointer#setFlyingImage(FlyingImage)
 */
public class FlyingImage {

	/**
	 * Creates a new <code>FlyingImage</code>. On creation the <code>FlyingImage</code> is not shown - call
	 * {@link #show()} to show it.
	 *
	 * @param skin
	 *            the <code>Image</code> the <code>FlyingImage</code> is associated with.
	 * @throws NullPointerException
	 *             if <code>skin</code> is null.
	 * @throws OutOfMemoryError
	 *             if there is not enough room to add a new flying image.
	 */
	public FlyingImage(final Image skin) {
		throw new RuntimeException();
	}

	/**
	 * Creates a new <code>FlyingImage</code>. On creation the <code>FlyingImage</code> is not shown - call
	 * {@link #show()} to show it.
	 *
	 * @param display
	 *            the <code>Display</code> where the <code>FlyingImage</code> will appears.
	 * @param skin
	 *            the <code>Image</code> the <code>FlyingImage</code> is associated with.
	 * @throws NullPointerException
	 *             if <code>skin</code> is null.
	 * @throws OutOfMemoryError
	 *             if there is not enough room to add a new flying image.
	 */
	public FlyingImage(final Display display, final Image skin) {
		throw new RuntimeException();
	}

	/**
	 * Sets the <code>FlyingImage</code> as visible on its display.
	 */
	public void show() {
		throw new RuntimeException();
	}

	/**
	 * Sets the <code>FlyingImage</code> as hidden on its display.
	 */
	public void hide() {
		throw new RuntimeException();
	}

	/**
	 * Checks whether the <code>FlyingImage</code> is visible on its display.
	 *
	 * @return <code>true</code> if the <code>FlyingImage</code> is currently visible, <code>false</code> otherwise
	 */
	public boolean isShown() {
		throw new RuntimeException();
	}

	/**
	 * Requests a repaint of the <code>FlyingImage</code>.
	 */
	public void repaint() {
		throw new RuntimeException();
	}

	/**
	 * Returns the image associated to the <code>FlyingImage</code>.
	 *
	 * @return the image associated to this <code>FlyingImage</code>
	 */
	public Image getImage() {
		throw new RuntimeException();
	}

	/**
	 * Sets the location of the <code>FlyingImage</code>.
	 *
	 * @param x
	 *            the x coordinate where to set the <code>FlyingImage</code>
	 * @param y
	 *            the y coordinate where to set the <code>FlyingImage</code>
	 */
	public void setLocation(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Get the x coordinate of the <code>FlyingImage</code> position
	 *
	 * @return the x coordinate of the <code>FlyingImage</code> position
	 */
	public int getX() {
		throw new RuntimeException();
	}

	/**
	 * Get the y coordinate of the <code>FlyingImage</code> position
	 *
	 * @return the y coordinate of the <code>FlyingImage</code> position
	 */
	public int getY() {
		throw new RuntimeException();
	}

	/**
	 * Returns the display associated to the <code>FlyingImage</code>.
	 *
	 * @return the display associated to the <code>FlyingImage</code>.
	 */
	public Display getDisplay() {
		throw new RuntimeException();
	}

}
