/*
 *	Java
 *
 *	Copyright 2015 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui;

/**
 * Interface for handlers invoked when MicroUI library receives an uncaught exception.
 * 
 * @see MicroUI#setUncaughtExceptionHandler(UncaughtExceptionHandler)
 * @since 2.0
 */
public interface UncaughtExceptionHandler {

	/**
	 * Method invoked when the given uncaught exception occurs in MicroUI library.
	 * 
	 * @param e
	 *            the uncaught exception.
	 */
	void uncaughtException(Throwable e);

}
