/*
 * Java
 *
 * Copyright 2016-2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.ecom.wifi;

import java.io.IOException;

/**
 * Manages the Wi-Fi capabilities.
 */
public class WifiManager {

	/**
	 * Returns the {@link WifiManager} instance.
	 *
	 * @return {@link WifiManager} instance.
	 */
	public static WifiManager getInstance() {
		throw new RuntimeException();
	}

	/**
	 * Disables the Software enabled Access Point (SoftAP).
	 *
	 * This method has no effect if the SoftAP is not started.
	 *
	 * @throws IOException
	 *             if an I/O error occurs
	 */
	public void disableSoftAP() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Enables the SoftAP with a given configuration.
	 *
	 * @param configuration
	 *            SoftAP configuration.
	 * @throws IOException
	 *             if SoftAP mode is not supported, an access point is currently
	 *             joined and the platform does support simultaneous mode
	 *             ({@link #leave()} must be called before this method) or an I/O
	 *             error occurs.
	 */
	public void enableSoftAP(SoftAPConfiguration configuration) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Gets the Wi-Fi capability of the platform.
	 *
	 * @return Wi-Fi capability.
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	public WifiCapability getCapability() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Gets the currently joined Wi-Fi access point.
	 *
	 * @return currently joined Wi-Fi access point or <code>null</code> if no Wi-Fi
	 *         access point has been joined yet.
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	public AccessPoint getJoined() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Tells whether if SoftAP is currently enabled.
	 *
	 * @return <code>true</code> if enabled, <code>false</code> otherwise.
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	public boolean isSoftAPEnabled() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Joins a Wi-Fi network using a Wi-Fi access point and a passphrase.
	 *
	 * @param accessPoint
	 *            Wi-Fi access point.
	 * @param passphrase
	 *            Wi-Fi access point passphrase.
	 * @throws IOException
	 *             if client mode is not supported, the SoftAP is currently enabled
	 *             and the platform does support simultaneous mode (
	 *             {@link #disableSoftAP()} must be called before this method), or
	 *             an I/O error occurs.
	 * @throws IllegalArgumentException
	 *             if the accessPoint or the passphrase is <code>null</code>.
	 */
	public void join(AccessPoint accessPoint, String passphrase) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Joins a Wi-Fi network using a Wi-Fi access point, a passphrase and a security
	 * mode.
	 *
	 * @param accessPoint
	 *            Wi-Fi access point.
	 * @param passphrase
	 *            Wi-Fi access point passphrase.
	 * @param securityMode
	 *            Wi-Fi access point security mode.
	 * @throws IOException
	 *             if client mode is not supported, the SoftAP is currently enabled
	 *             and the platform does support simultaneous mode (
	 *             {@link #disableSoftAP()} must be called before this method), or
	 *             an I/O error occurs.
	 * @throws IllegalArgumentException
	 *             if the accessPoint or the passphrase is <code>null</code>.
	 */
	public void join(AccessPoint accessPoint, String passphrase, SecurityMode securityMode) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Joins a Wi-Fi network using a SSID and a passphrase.
	 *
	 * @param SSID
	 *            Wi-Fi access point Service Set Identifier (SSID).
	 * @param passphrase
	 *            Wi-Fi access point passphrase.
	 * @throws IOException
	 *             if client mode is not supported, the SoftAP is currently enabled
	 *             and the platform does support simultaneous mode (
	 *             {@link #disableSoftAP()} must be called before this method), or
	 *             an I/O error occurs.
	 * @throws IllegalArgumentException
	 *             if the SSID or the passphrase is <code>null</code>.
	 */
	public void join(String SSID, String passphrase) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Joins a wireless network using an SSID and a passphrase.
	 *
	 * @param SSID
	 *            Wi-Fi access point Service Set Identifier (SSID).
	 * @param passphrase
	 *            Wi-Fi access point passphrase.
	 * @param securityMode
	 *            Wi-Fi access point security mode.
	 * @throws IOException
	 *             if client mode is not supported, the SoftAP is currently enabled
	 *             and the platform does support simultaneous mode (
	 *             {@link #disableSoftAP()} must be called before this method), or
	 *             an I/O error occurs.
	 * @throws IllegalArgumentException
	 *             if the SSID or the passphrase is <code>null</code>.
	 */
	public void join(String SSID, String passphrase, SecurityMode securityMode) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Leaves the currently joined Wi-Fi access point. If no Wi-Fi access point has
	 * been joined yet, this method has no effect.
	 *
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	public void leave() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Performs an active scan of available Wi-Fi access points. This is equivalent
	 * to <code>scan(true)</code>.
	 *
	 * @return the list of available Wi-Fi access points or an empty list if there
	 *         is no available Wi-Fi access point.
	 * @throws IOException
	 *             if the underlying Wi-Fi network interface is currently stopped,
	 *             scanning is not possible at the moment, or an I/O error occurs.
	 */
	public AccessPoint[] scan() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Performs a scan of available access points.
	 *
	 * @param active
	 *            <code>true</code> for an active scan, <code>false</code> for a
	 *            passive scan.
	 * @return the list of available access points or an empty list if there is no
	 *         available Wi-Fi access point.
	 * @throws IOException
	 *             if the underlying network interface is currently stopped,
	 *             scanning is not possible at the moment, or an I/O error occurs.
	 */
	public AccessPoint[] scan(boolean active) throws IOException {
		throw new RuntimeException();
	}

}
