/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.tool.addon.util;

public class DefaultMessageLogger implements MessageLogger {
	private int level = Message.MSG_INFO;

	public DefaultMessageLogger(int level) {
		this.level = level;
	}

	@Override
	public void debug(String msg) {
		log(msg, Message.MSG_DEBUG);
	}

	@Override
	public void verbose(String msg) {
		log(msg, Message.MSG_VERBOSE);
	}

	@Override
	public void info(String msg) {
		log(msg, Message.MSG_INFO);
	}

	@Override
	public void warn(String msg) {
		log("WARN: " + msg, Message.MSG_WARN);
	}

	@Override
	public void error(String msg) {
		log("ERROR: " + msg, Message.MSG_ERR);
	}

	@Override
	public void log(String msg, int level) {
		if (level <= this.level) {
			System.out.println(msg);
		}
	}

	public int getLevel() {
		return this.level;
	}
}
