/*
 * Java
 *
 * Copyright 2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.tool.addon;

import java.io.File;

/**
 * A delta is a change in a project.
 */
public final class Delta {

	/**
	 * An enumeration of possible kind of deltas.
	 */
	public enum DeltaKind {
		/**
		 * The resource associated to the delta has been added to project.
		 */
		Added,
		/**
		 * The resource associated to the delta has been removed from project.
		 */
		Removed,
		/**
		 * The resource associated to the delta has been modified.
		 */
		Modified
	}

	private final File _project; // NOSONAR
	private final File _referrerFolder; // NOSONAR
	private final File _delta; // NOSONAR
	private final DeltaKind _deltaKind; // NOSONAR
	private final FolderKind _referrerFolderKind; // NOSONAR

	/**
	 * Instantiates a new delta on given file.
	 *
	 * @param project
	 *            the project associated with this delta.
	 * @param referrerFolder
	 *            the folder that holds the created delta.
	 * @param delta
	 *            the delta file.
	 * @param deltaKind
	 *            the kind of changed applied to the delta file.
	 * @param refererFolderKind
	 *            the referrer folder kind.
	 */
	public Delta(File project, File referrerFolder, File delta, DeltaKind deltaKind, FolderKind refererFolderKind) {
		this._project = project;
		this._delta = delta;
		this._referrerFolder = referrerFolder;
		this._deltaKind = deltaKind;
		this._referrerFolderKind = refererFolderKind;
	}

	/**
	 * Gets the root folder of the project that holds the resource of this delta.
	 *
	 * @return the path to the root folder of the project that holds the delta.
	 */
	public File getProject() {
		return this._project;
	}

	/**
	 * Gets the resource that have been modified.
	 *
	 * @return the pathname to the resource that have been modified.
	 */
	public File getDelta() {
		return this._delta;
	}

	/**
	 * Gets the referrer folder of this delta.
	 *
	 * <p>
	 * For example, for a Java source file creation, the referrer folder is the source folder that contains the created
	 * Java source file.
	 *
	 * @return the pathname to the referrer folder of this delta.
	 */
	public File getReferrerFolder() {
		return this._referrerFolder;
	}

	/**
	 * Gets the kind of this delta.
	 *
	 * @return the delta kind.
	 */
	public DeltaKind getDeltaKind() {
		return this._deltaKind;
	}

	/**
	 * Gets the kind of the referrer folder of this delta.
	 *
	 * @return the kind of the referrer folder of this delta.
	 */
	public FolderKind getReferrerFolderKind() {
		return this._referrerFolderKind;
	}

}
