/**
 * Java
 *
 * Copyright 2011 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

/**
 * <p>
 * This class gives access to the global immortal objects pool.
 * </p>
 * <p>
 * An immortal object has two major properties:
 * <ol>
 * <li>it is not managed by the garbage collector,</li>
 * <li>it does not move around in memory, i.e. its physical memory location remains the same forever.</li>
 * </ol>
 * </p>
 */
public class Immortals {

	/**
	 * <p>
	 * Gets whether an object is immortal or not.
	 * </p>
	 * <p>
	 * An object is immortal:
	 * <ul>
	 * <li>if it has been declared as immortal calling {@link #setImmortal(Object)},</li>
	 * <li>if it is immutable.</li>
	 * </ul>
	 * </p>
	 *
	 * @param o
	 *            the object to check
	 * @return <code>true</code> if the queried object is immortal or immutable, <code>false</code> otherwise
	 * @throws NullPointerException
	 *             if given object is null
	 * @see Immutables#isImmutable(Object)
	 */
	public static boolean isImmortal(Object o){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Turns the given object into an immortal object.<br>
	 * </p>
	 * <p>
	 * If the received object was immutable, it remains immutable.<br>
	 * If the object was already immortal, it remains immortal.<br>
	 * If the object was a reclaimable object it turns into an immortal object. Upon success, the returned object is immortal,
	 * otherwise an {@link OutOfMemoryError} is thrown.<br>
	 * </p>
	 *
	 * @return the given object turned into immortal
	 * @throws OutOfMemoryError
	 *             if the immortal memory is full
	 */
	public static Object setImmortal(Object o) {
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Turns the given object and all objects referred from it into immortal objects.
	 * </p>
	 * <p>
	 * Weakly reachable objects are not turned into immortal objects.
	 * </p>
	 *
	 * @param root
	 *            the root of the objects graph to turn into immortal
	 * @return the given object turned into immortal
	 */
	public static Object deepImmortal(Object root){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Calls the method {@link Runnable#run()} of the given runnable.
	 * </p>
	 * <p>
	 * All the objects allocated in the context of this method are directly allocated as immortals. While the
	 * {@link Runnable#run()} method of the runnable executes all created objects are allocated as immortal objects.
	 * </p>
	 *
	 * @param runnable
	 *            the runnable to execute
	 * @throws NullPointerException
	 *             if the given runnable is <code>null</code>
	 */
	public static void run(Runnable runnable){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Returns the amount of free immortal memory still available.
	 * </p>
	 *
	 * @return the amount of free immortal memory
	 */
	public static long freeMemory(){
		throw new RuntimeException();
	}

	/**
	 * <p>
	 * Returns the total amount of immortal memory.
	 * </p>
	 * <p>
	 * Note that the amount of memory required to hold an object of any given type may be implementation-dependent.
	 * </p>
	 *
	 * @return the total amount of immortal memory
	 */
	public static long totalMemory(){
		throw new RuntimeException();
	}

}