/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2015-2022 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package java.security;

import ej.annotation.Nullable;

/**
 * This is the generic Message Digest exception.
 *
 * @author Benjamin Renaud
 */
public class DigestException extends GeneralSecurityException {

	private static final long serialVersionUID = 5821450303093652515L;

	/**
	 * Constructs a DigestException with no detail message. (A detail message is a String that describes this particular
	 * exception.)
	 */
	public DigestException() {
		super();
	}

	/**
	 * Constructs a DigestException with the specified detail message. (A detail message is a String that describes this
	 * particular exception.)
	 *
	 * @param msg
	 *            the detail message.
	 */
	public DigestException(String msg) {
		super(msg);
	}

	/**
	 * Creates a {@code DigestException} with the specified detail message and cause.
	 *
	 * @param message
	 *            the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
	 * @param cause
	 *            the cause (which is saved for later retrieval by the {@link #getCause()} method). (A {@code null}
	 *            value is permitted, and indicates that the cause is nonexistent or unknown.)
	 * @since 1.5
	 */
	public DigestException(String message, @Nullable Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates a {@code DigestException} with the specified cause and a detail message of
	 * {@code (cause==null ? null : cause.toString())} (which typically contains the class and detail message of
	 * {@code cause}).
	 *
	 * @param cause
	 *            the cause (which is saved for later retrieval by the {@link #getCause()} method). (A {@code null}
	 *            value is permitted, and indicates that the cause is nonexistent or unknown.)
	 * @since 1.5
	 */
	public DigestException(@Nullable Throwable cause) {
		super(cause);
	}
}
