/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util.server;

import ej.bluetooth.BluetoothDevice;

/**
 * A callback when a read write
 */
public interface ReadWriteCallbackServer {

	/**
	 * Called back when a read request is received.
	 *
	 * @param device
	 *            the device doing the read request.
	 */
	void onReadRequest(BluetoothDevice device);

	/**
	 * Called back when a write request is received.
	 *
	 * @param device
	 *            the device doing the write request.
	 * @param value
	 *            the value to write.
	 */
	void onWriteRequest(BluetoothDevice device, byte[] value);
}
