/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util.server;

import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.BluetoothUuid;

/**
 * A descriptor that can receive write an read request.
 */
public class BasicServerDescriptor extends BluetoothDescriptor implements ReadWriteCallbackServer {

	/**
	 * Instantiates a {@link BasicServerDescriptor}.
	 *
	 * @param uuid
	 *            the uuid to use.
	 * @param permissions
	 *            the permissions of the {@link BluetoothDescriptor}.
	 */
	public BasicServerDescriptor(BluetoothUuid uuid, int permissions) {
		super(uuid, permissions);
	}

	@Override
	public void onWriteRequest(BluetoothDevice device, byte[] value) {
		// Nothing to do.
	}

	@Override
	public void onReadRequest(BluetoothDevice device) {
		// Nothing to do.

	}

}
