/*
 * Java
 *
 * Copyright 2015-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Kernel;

public abstract class RunnableWithResult<R> implements Runnable {

	private R result;

	protected void setResult(R result) {
		Kernel.enter();
		this.result = result;
		// Kernel.exit();
	}

	/**
	 * Gets the result.
	 *
	 * @return the result.
	 */
	public R getResult() {
		return this.result;
	}

	/**
	 * By default sets the result returned by {@link #runWithResult()}.
	 */
	@Override
	public final void run() {
		setResult(runWithResult());
	}

	protected abstract R runWithResult();

}