/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.display;

import java.awt.geom.GeneralPath;

import ej.microui.display.LLUIPainter;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGConstants;
import ej.microvg.paint.VGPaint;

/**
 * Nema specific drawer for the display.
 * <p>
 * It disables the drawing of blend modes SCREEN and MULTIPLY (not supported by the GPU).
 */
public class NemaDisplayDrawer extends DisplayDrawer {

	@Override
	public void drawPath(MicroUIGraphicsContext gc, GeneralPath path, float x, float y, float[] matrix, int fillRule,
			int blend, VGPaint paint) {
		if (blend == LLVGConstants.BLEND_SCREEN || blend == LLVGConstants.BLEND_MULTIPLY) {
			gc.reportError(LLUIPainter.DRAWING_LOG_NOT_IMPLEMENTED);
		} else {
			super.drawPath(gc, path, x, y, matrix, fillRule, blend, paint);
		}
	}

}
