/*
 * Copyright (c) 1996, 2020, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2021-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package sun.security.x509;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;

import ej.annotation.Nullable;

/**
 *
 * Use this class to get OID of supported algorithms see {@link AlgorithmId#get(String)}
 *
 * The OID is handled in it's String format in this class. example 1.2.840.113549.1.1.11 for "SHA256withRSA"
 *
 * @author David Brownell
 * @author Amit Kapoor
 * @author Hemma Prafullchandra
 */
public class AlgorithmId implements Serializable {

	/** use serialVersionUID from JDK 1.1. for interoperability */
	private static final long serialVersionUID = 7205873507486557157L;

	/**
	 * Constructs an algorithm ID which will be initialized separately, for example by deserialization.
	 *
	 * @deprecated use one of the other constructors.
	 */
	@Deprecated
	public AlgorithmId() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a parameterless algorithm ID.
	 *
	 * @param oid
	 *            the identifier for the algorithm
	 */
	public AlgorithmId(String oid) {
		throw new RuntimeException();
	}

	/**
	 * Returns the ISO OID for this algorithm. This is usually converted to a string and used as part of an algorithm
	 * name, for example "OID.1.3.14.3.2.13" style notation. Use the <code>getName</code> call when you do not need to
	 * ensure cross-system portability of algorithm names, or need a user friendly name.
	 *
	 * @return
	 */
	public final String getOID() {
		throw new RuntimeException();
	}

	/**
	 * Returns true iff the argument indicates the same algorithm with the same parameters.
	 *
	 * @param other
	 * @return
	 */
	public boolean equals(AlgorithmId other) {
		throw new RuntimeException();
	}

	/**
	 * Compares this AlgorithmID to another. If algorithm parameters are available, they are compared. Otherwise, just
	 * the object IDs for the algorithm are compared.
	 *
	 * @param other
	 *            preferably an AlgorithmId, else an ObjectIdentifier
	 */
	@Override
	public boolean equals(@Nullable Object other) {
		throw new RuntimeException();
	}

	/**
	 * Compares two algorithm IDs for equality. Returns true iff they are the same algorithm, ignoring algorithm
	 * parameters.
	 */
	public final boolean equals(String id) {
		throw new RuntimeException();
	}

	/**
	 * Returns a hashcode for this AlgorithmId.
	 *
	 * @return a hashcode for this AlgorithmId.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns one of the algorithm IDs most commonly associated with this algorithm name.
	 *
	 * @param algname
	 *            the name being used
	 * @deprecated use the short get form of this method.
	 * @exception NoSuchAlgorithmException
	 *                on error.
	 */
	@Deprecated
	public static AlgorithmId getAlgorithmId(String algname) throws NoSuchAlgorithmException {
		throw new RuntimeException();
	}

	/**
	 * Returns one of the algorithm IDs most commonly associated with this algorithm name.
	 *
	 * @param algname
	 *            the name being used
	 * @exception NoSuchAlgorithmException
	 *                on error.
	 */
	public static AlgorithmId get(String algname) throws NoSuchAlgorithmException {
		throw new RuntimeException();
	}

	/**
	 * Creates a signature algorithm name from a digest algorithm name and a encryption algorithm name.
	 */
	public static String makeSigAlg(String digAlg, String encAlg) {
		throw new RuntimeException();
	}

	/**
	 * Extracts the encryption algorithm name from a signature algorithm name.
	 */
	public static String getEncAlgFromSigAlg(String signatureAlgorithm) {
		throw new RuntimeException();
	}

	/**
	 * Extracts the digest algorithm name from a signature algorithm name.
	 */
	public static String getDigAlgFromSigAlg(String signatureAlgorithm) {
		throw new RuntimeException();
	}
}
