/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2015-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package java.security;

import ej.annotation.Nullable;

/**
 * This exception is thrown when a particular cryptographic algorithm is requested but is not available in the
 * environment.
 *
 * @author Benjamin Renaud
 */

public class NoSuchAlgorithmException extends GeneralSecurityException {

	private static final long serialVersionUID = -7443947487218346562L;

	/**
	 * Constructs a NoSuchAlgorithmException with no detail message. A detail message is a String that describes this
	 * particular exception.
	 */
	public NoSuchAlgorithmException() {
		super();
	}

	/**
	 * Constructs a NoSuchAlgorithmException with the specified detail message. A detail message is a String that
	 * describes this particular exception, which may, for example, specify which algorithm is not available.
	 *
	 * @param msg
	 *            the detail message.
	 */
	public NoSuchAlgorithmException(String msg) {
		super(msg);
	}

	/**
	 * Creates a {@code NoSuchAlgorithmException} with the specified detail message and cause.
	 *
	 * @param message
	 *            the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
	 * @param cause
	 *            the cause (which is saved for later retrieval by the {@link #getCause()} method). (A {@code null}
	 *            value is permitted, and indicates that the cause is nonexistent or unknown.)
	 * @since 1.5
	 */
	public NoSuchAlgorithmException(String message, @Nullable Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates a {@code NoSuchAlgorithmException} with the specified cause and a detail message of
	 * {@code (cause==null ? null : cause.toString())} (which typically contains the class and detail message of
	 * {@code cause}).
	 *
	 * @param cause
	 *            the cause (which is saved for later retrieval by the {@link #getCause()} method). (A {@code null}
	 *            value is permitted, and indicates that the cause is nonexistent or unknown.)
	 * @since 1.5
	 */
	public NoSuchAlgorithmException(@Nullable Throwable cause) {
		super(cause);
	}
}
