/*
 * Copyright 2016-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.cbor;

import ej.util.message.Level;
import ej.util.message.basic.BasicMessageBuilder;

/**
 *
 */
public class ErrorMessage {

    public static final int INVALID_ARRAY_LENGHT = 0;
    public static final int INVALID_MAP_LENGHT = 1;
    public static final int TAG_CANNOT_BE_NEGATIVE = 2;
    public static final int UNEXPECTED_BOOLEAN_VALUE = 3;
    public static final int INFINITE_LENGTH_BYTE_STRING_NOT_SUPPORTED = 4;
    public static final int STRING_LENGTH_TOO_LONG = 5;
    public static final int INFINITE_LENGHT_TEXT_STRING_NOT_SUPPORTED = 6;
    public static final int UNEXPECTED_TYPE = 7;
    public static final int UNEXPECTED_TYPE_TWO_TYPES = 8;
    public static final int UNEXPECTED_SUBTYPE = 9;
    public static final int NOT_WELL_FORMED_CBOR_INTEGER = 10;
    public static final int UNEXPECTED_PAYLOAD_OR_LENGTH = 11;
    public static final int NO_PAYLOAD = 12;
    public static final int ONE_BYTE = 13;
    public static final int TWO_BYTES = 14;
    public static final int FOUR_BYTES = 15;
    public static final int EIGHT_BYTES = 16;
    public static final int UNKNOWN = 17;
    public static final int INVALID_MAJOR_TYPE = 18;

    private static final String MESSAGE_CATEGORY = "CBOR";
    private static final ErrorMessage ERR = new ErrorMessage();

    /**
     * Gets the default instance of {@link ErrorMessage}.
     * 
     * @return the default {@link ErrorMessage} instance.
     */
    public static ErrorMessage getDefault() {
        return ERR;
    }

    /**
     * Generates {@link String} for a specified error code.
     * 
     * @param errorCode the error code corresponding to the message.
     * @param args the optional list of arguments to construct the message {@link String}.
     * @return the error message {@link String}.
     */
    public String messageAt(int errorCode, Object... args) {
        return BasicMessageBuilder.INSTANCE.buildMessage(Level.SEVERE, MESSAGE_CATEGORY, errorCode, args);
    }

}
