/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.util.logging.handler;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * This is the default handler for logging. It is associated with the RootLogger by default.
 */
public class DefaultHandler extends Handler {

	@Override
	public void close() throws SecurityException {
		// Nothing to do
	}

	@Override
	public void flush() {
		// Nothing to do
	}

	@Override
	public void publish(LogRecord record) {
		System.err.println(record.getLoggerName() + " " + record.getLevel() + ": " + record.getMessage());
		Throwable thrown = record.getThrown();
		if (thrown != null) {
			thrown.printStackTrace(System.err);
		}
	}

}
