/*
 * Copyright 2013-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * This interface represents and identifies the Kernel or a Feature. Identification uses the 6 well-known fields defined
 * in <code>RFC 2253</code>.
 *
 * <pre>
 * CN      commonName
 * L       localityName
 * ST      stateOrProvinceName
 * O       organizationName
 * OU      organizationalUnitName
 * C       countryName
 * </pre>
 */
public interface Principal {

	/**
	 * CN: Common name
	 */
	int FIELD_CN = 0;

	/**
	 * L: Locality
	 */
	int FIELD_L = 1;

	/**
	 * ST: State or Province
	 */
	int FIELD_ST = 2;

	/**
	 * O: Organization
	 */
	int FIELD_O = 3;

	/**
	 * OU: Organizational Unit
	 */
	int FIELD_OU = 4;

	/**
	 * C: Country
	 */
	int FIELD_C = 5;

	/**
	 * Gets the value of one of the fields.
	 *
	 * @param field
	 *            One of the 6 well-known fields.
	 * @throws IndexOutOfBoundsException
	 *             if field is out of bounds.
	 * @return the value of the required field.
	 */
	String getValue(int field);

	/**
	 * Gets a string representation of the X.500 distinguished name using the format defined in RFC 2253.
	 */
	@Override
	String toString();

}
