/*
 * Copyright 2013-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * Each Feature shall define one entry point that implements this interface. Methods are called by the Kernel.
 */
public interface FeatureEntryPoint {

	/**
	 * This method is called once by the Kernel when a Feature has been newly started. It is executed in a dedicated
	 * thread owned by the Feature, so it may consider it as its "main" thread. This allows a Feature to connect to the
	 * application (by adding new Feature points, services, ...)
	 */
	public void start();

	/**
	 * This method is called once by the Kernel when a Feature is going to be unloaded. It is executed in a dedicated
	 * thread owned by the Feature. Feature is responsible to do its best effort to properly stop threads and close
	 * resources it has created as soon as possible.
	 */
	public void stop();

}
