/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class DisableCommand extends Command<Object> {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_DISABLE;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		// do nothing
	}

	@Override
	public Object readResponseInternal(CommandReader reader) throws IOException {
		return VOID_RESPONSE;
	}
}
