/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.util.message.basic;

import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;

/**
 * A message logger that does not print anything.
 */
public class OffMessageLogger implements MessageLogger {

	/**
	 * An instance of OffMessageLogger.
	 */
	public static final OffMessageLogger INSTANCE = new OffMessageLogger();

	/**
	 * Creates an instance.
	 */
	public OffMessageLogger() {
		// Do nothing.
	}

	@Override
	public void log(char level, String category, int id) {
		// Do not print.
	}

	@Override
	public void log(char level, String category, int id, Throwable t) {
		// Do not print.
	}

	@Override
	public void log(char level, String category, int id, Object... arguments) {
		// Do not print.
	}

	@Override
	public void log(char level, String category, int id, Throwable t, Object... arguments) {
		// Do not print.
	}

	@Override
	public MessageBuilder getMessageBuilder() {
		return null;
	}

	@Override
	public void setMessageBuilder(MessageBuilder builder) {
		// Do nothing.
	}
}
