package ej.ecom.io;

import java.io.IOException;


/**
 * This interface defines an open Connection.
 */
public interface Connection {

    /**
     * Close the connection. If the connection has already been closed or a close is pending, this method does nothing.
     * If the connection has underlying open streams, the connection will be closed only when these streams will be closed.
     * @throws IOException if an I/O error occurs
     */
    public void close() throws IOException ;
  
}
