/*
 * Decompiled with CFR 0.152.
 */
package ej.benchmark;

import ej.benchmark.BenchResult;
import ej.benchmark.BenchTest;
import ej.benchmark.time.PlatformTimeStrategy;
import ej.benchmark.time.TimeStrategy;

public class BenchHelper {
    private BenchHelper() {
    }

    public static BenchResult run(BenchTest test) {
        return BenchHelper.run(test, new PlatformTimeStrategy());
    }

    public static BenchResult run(BenchTest test, TimeStrategy time) {
        test.pre();
        int iterations = test.getNumberOfIterations();
        long startEmptyTime = time.getTime();
        int i = 0;
        while (i < iterations) {
            test.emptyRun();
            ++i;
        }
        long emptyRunTime = time.getTime() - startEmptyTime;
        long startTime = time.getTime();
        int i2 = 0;
        while (i2 < iterations) {
            test.run();
            ++i2;
        }
        long fullTime = time.getTime() - startTime;
        test.post();
        if (emptyRunTime > fullTime) {
            throw new AssertionError((Object)"An error occured, empty run was shorter than normal run");
        }
        return new BenchResult(test, iterations, emptyRunTime, fullTime);
    }
}

