/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender.helper;

import com.microej.tool.classextender.helper.ClassPoolHelper;
import com.microej.tool.classextender.helper.MethodHelper;
import ej.basictool.annotation.Extend;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.ClassFile;

public class ExtendClassFilter
implements FileFilter {
    private static final Logger LOGGER = Logger.getLogger(ExtendClassFilter.class.getName());
    private final ClassPoolHelper classPool;

    public ExtendClassFilter(File ... classpath) {
        this.classPool = new ClassPoolHelper(classpath);
    }

    @Override
    public boolean accept(File file) {
        if (!file.getAbsolutePath().endsWith(".class")) {
            return false;
        }
        try {
            return this.containsExtensionMethod(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOGGER.finest(e.getMessage());
            return false;
        }
    }

    public boolean accept(JarFile jarFile, JarEntry jarEntry) {
        if (!jarEntry.getName().endsWith(".class")) {
            return false;
        }
        try {
            return this.containsExtensionMethod(jarFile.getInputStream(jarEntry));
        }
        catch (IOException e) {
            LOGGER.finest(e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsExtensionMethod(InputStream classInputStream) {
        String className = this.getNameFromFile(classInputStream);
        try {
            CtClass clazz = this.classPool.getClass(className);
            CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
            int n = ctMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                CtMethod method = ctMethodArray[n2];
                boolean isStatic = MethodHelper.hasStaticModifier(method.getModifiers());
                boolean hasExtendAnnotation = method.hasAnnotation(Extend.class);
                LOGGER.log(Level.FINEST, "Analyzing method {0} from {1}: static={2} extend={3}", new Object[]{method.getName(), clazz.getName(), isStatic, hasExtendAnnotation});
                if (isStatic && hasExtendAnnotation) {
                    return true;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.finest(e.getMessage());
            return false;
        }
    }

    private String getNameFromFile(InputStream classInputStream) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DataInputStream is = new DataInputStream(classInputStream);){
                ClassFile classFile = new ClassFile(is);
                return classFile.getName();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.finest(e.getMessage());
            return null;
        }
    }
}

