/*
 * Decompiled with CFR 0.152.
 */
package ej.junit;

import ej.junit.AbstractTestWrapper;
import ej.junit.TestListener;
import ej.junit.TestWrapper;

public abstract class AbstractAllTestClassesWrapper
implements TestWrapper {
    private int runs;
    private int failures;
    private int errors;
    protected TestListener testListener;

    protected abstract void runTestClasses();

    protected synchronized void wrapperRunTestClass(AbstractTestWrapper test) {
        try {
            try {
                test.failures = 0;
                test.errors = 0;
                test.testListener = this.testListener;
                boolean ok = test.wrapperRunBeforeClassMethod();
                if (ok) {
                    test.runTestMethods();
                }
            }
            finally {
                this.runs += test.runs;
                this.errors += test.errors;
                this.failures += test.failures;
                test.wrapperRunAfterClassMethod();
            }
        }
        catch (Throwable t) {
            test.reportError(t);
        }
    }

    @Override
    public String getTestClass() {
        return this.getClass().getName();
    }

    @Override
    public synchronized boolean run(TestListener listener) {
        this.failures = 0;
        this.errors = 0;
        this.testListener = listener;
        if (this.testListener != null) {
            this.testListener.onSuiteStart(this.getTestClass());
        }
        this.runTestClasses();
        if (this.testListener != null) {
            this.testListener.onSuiteEnd(this.getTestClass(), this.runs, this.failures, this.errors);
        }
        return this.errors == 0 && this.failures == 0;
    }
}

